#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h>
#include <openplx/Physics3D/Geometries/Box.h>
#include <openplx/Vehicles/Tracks/BoxLinkVariation.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model BoxLinkDescription */
namespace openplx::Vehicles::Tracks {
    /**
     * Link description for a track belt with a contact_geometry with the shape of a box,
     * and possible variations in size given BoxLinkVariation type.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT BoxLinkDescription : public openplx::Vehicles::Tracks::ContactGeometryLinkDescription {
        protected:
            double m_width;
            double m_height;

        public:
            BoxLinkDescription();
            virtual ~BoxLinkDescription();
            double width() const;
            double height() const;
            std::shared_ptr<openplx::Physics3D::Geometries::Box> contact_geometry() const;
            std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation> variation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
