#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/Interactions/RedirectedMateConnector.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Connector */
namespace openplx::Vehicles::Suspensions::Interactions {
    /**
     * Connector for Vehicle Suspension.
     * 'up_vector'      - Reference to the up vector of a vehicle.
     * 'forward_vector' - Reference to the forward vector of a vehicle.
     * 'main_axis'      - The wheel axis computed by taking the cross product of the up and forward vector.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT Connector : public openplx::Physics3D::Interactions::RedirectedMateConnector {
        protected:
            std::weak_ptr<openplx::Math::Vec3> m_up_vector;
            std::weak_ptr<openplx::Math::Vec3> m_forward_vector;

        public:
            Connector();
            virtual ~Connector();
            std::shared_ptr<openplx::Math::Vec3> up_vector() const;
            std::shared_ptr<openplx::Math::Vec3> forward_vector() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
