#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
/* Generated code for model DistortedRayEmission */
namespace openplx::Sensors::Optics::Traits {
    /**
     *     Trait for models where the emitted rays are distorted on emission.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT DistortedRayEmission {
        public:
            DistortedRayEmission();
            virtual ~DistortedRayEmission();
            virtual std::vector<std::shared_ptr<openplx::Sensors::Optics::RayEmissionDistortion>> ray_emission_distortions() const = 0;
    };
}
