#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>
#include <openplx/Physics3D/Geometries/ContactGeometry.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RigidLink */
namespace openplx::Robotics::Links {
    /**
     * An empty rigid link, user needs to add geometry, inertia and mate connectors start and end.
     **/
    class OPENPLX_Robotics_BUNDLE_EXPORT RigidLink : public openplx::Physics3D::Bodies::RigidBody {
        protected:
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_start;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_end;
            std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry> m_contact_geometry;

        public:
            RigidLink();
            virtual ~RigidLink();
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> start() const;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> end() const;
            std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry> contact_geometry() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
