#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/SpringInteraction1DOF.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/AngleOutputTrait.h>
#include <openplx/Physics/Signals/AngleInputTrait.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
#include <openplx/Physics/Signals/AngleOutput.h>
#include <openplx/Physics/Signals/AngleInput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model TorsionSpring */
namespace openplx::Physics3D::Interactions {
    class OPENPLX_Physics3D_BUNDLE_EXPORT TorsionSpring : public openplx::Physics3D::Interactions::SpringInteraction1DOF, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::AngleOutputTrait, public openplx::Physics::Signals::AngleInputTrait {
        protected:
            double m_angle;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> m_target_angle_output;
            std::shared_ptr<openplx::Physics::Signals::AngleInput> m_target_angle_input;

        public:
            TorsionSpring();
            virtual ~TorsionSpring();
            double angle() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> target_angle_output() const;
            std::shared_ptr<openplx::Physics::Signals::AngleInput> target_angle_input() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
