#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultMateFlexibility.h>
#include <openplx/Physics/Interactions/Flexibility/DefaultFlexibility.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DefaultPrismaticFlexibility */
namespace openplx::Physics3D::Interactions::Flexibility {
    /**
     *     Defines one flexibility model for each constrained degree of freedom for a Prismatic    
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT DefaultPrismaticFlexibility : public openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_along_normal;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_along_cross;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_around_main;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_around_normal;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_around_cross;

        public:
            DefaultPrismaticFlexibility();
            virtual ~DefaultPrismaticFlexibility();
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> along_normal() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> along_cross() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> around_main() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> around_normal() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> around_cross() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
