#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/Marshalling.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Output */
namespace openplx::Physics::Signals {
    /**
     * An Output, i.e. a sender of signals.
     * - Each Output must have a type-attribute, e.g. InputOutputType.Torque1D, Angle, AngularVelocity or any other InputOutputType.
     * - Use type Composite when the Output sends a Signal with multiple values.
     **/
    class OPENPLX_Physics_BUNDLE_EXPORT Output : public openplx::Core::Object {
        protected:
            int64_t m_type;
            bool m_enabled;
            std::shared_ptr<openplx::Physics::Signals::Marshalling> m_marshalling;

        public:
            Output();
            virtual ~Output();
            int64_t type() const;
            bool enabled() const;
            std::shared_ptr<openplx::Physics::Signals::Marshalling> marshalling() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
