#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
/* Generated code for model SurfaceViscosity */
namespace openplx::Physics::Interactions::SurfaceContact::Traits {
    /**
     * The surface viscosity in [N/(m/s)].
     * To be used with a DryFriction model where 0 (zero) is completely dry
     * and viscosity > 0 introduces a viscous friction term.
     *
     * works with Physics.Interactions.Dissipation.DefaultDryFriction
     **/
    class OPENPLX_Physics_BUNDLE_EXPORT SurfaceViscosity {
        public:
            SurfaceViscosity();
            virtual ~SurfaceViscosity();
            virtual double viscosity() const = 0;
    };
}
