#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDryFriction.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DryScaleBoxFriction */
namespace openplx::Physics::Interactions::Dissipation {
    /**
     *     Defines a constant maximum friction forces,linear dof's, or torques, around angular dof's,
     *     given the current normal force between the involved two interacting bodies. 
     *     The difference between ScaleBox and Box friction is that ScaleBox defines the 
     *     maximum friction depending on the actual forces between the objects.
     *     There are obvious artifacts that comes with the ScaleBox method.
     *     First of all, it is anisotropic due to the box shape of the possible friction forces in the friction plane.
     *     The actual resulting friction forces is sqrt(2) times larger in the local XY direction than the X or Y direction.
     *     This issue is accounted for with the DryCone friction method, where a friction cone is computed.
     *     Another issue is the nonlinear behaviour, where in non-ideal situations, the normal and force depend on each other,
     *     and it is computationally very expensive to find a good solution.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT DryScaleBoxFriction : public openplx::Physics::Interactions::Dissipation::DefaultDryFriction {
        protected:

        public:
            DryScaleBoxFriction();
            virtual ~DryScaleBoxFriction();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
