#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Dissipation/DryConstantNormalForceFriction.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DryDepthScaledConstantNormalForceFriction */
namespace openplx::Physics::Interactions::Dissipation {
    /**
     *     The DryDepthScaledConstantNormalForceFriction extends the DryConstantNormalForceFriction model
     *     by scaling the normal force for each contact point by the depth of the point, depth_p, in meters.
     *     For varying elasticity of surface contacts, the geometrical overlap and therefore the contact point depths,
     *     may differ  alot. To maintain comparable friction inbetween these different surface contact models a
     *     depth_factor parameter is introduced.
     *
     *     The friction limit, f_l, is always going to be:
     *     f_l = normal_force * depth_p * depth_factor * coefficient.
     *
     *     The model must be considered VERY approximative, since it does not consider friction as
     *     a non-linear problem.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT DryDepthScaledConstantNormalForceFriction : public openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction {
        protected:
            double m_depth_factor;

        public:
            DryDepthScaledConstantNormalForceFriction();
            virtual ~DryDepthScaledConstantNormalForceFriction();
            double depth_factor() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
