#pragma once

#include <memory>
#include <openplx/Node.h>

namespace openplx {

    /**
     * The InnerSymbol represents the first intermediate representation in the
     * semantic analysis. Using the TreeNode class we can build a symbol tree
     * of InnerSymbol nodes that sort each syntax tree node by which symbol
     * it is declaring some property for.
     */
    class InnerSymbol : public Node, public std::enable_shared_from_this<InnerSymbol>
    {
        public:
            static std::shared_ptr<InnerSymbol> create();

            /* Overrides */
            void unbind() override;
            InnerSymbolPtr asInnerSymbol() override;
            void accept(NodeVisitor& visitor) override;

            /* Accessors */
            const std::vector<NodePtr>& getDeclarations() const;

            /* Mutations */
            void appendToDeclarations(NodePtr declaration);

        protected:
            InnerSymbol();
            std::vector<NodePtr> m_declarations;
    };
}
