
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Type.h>

namespace openplx
{
    class InitializerType : public Type, public std::enable_shared_from_this<InitializerType>
    {
        public:
            /* Factories */
            static InitializerTypePtr create(InitializerPtr initializer);

            /* Overrides */
            InitializerTypePtr asInitializerType() override;
            TypePtr asType() override;
            void accept(NodeVisitor& visitor) override;
            bool isAssignableTo(const TypePtr &other) override;
            std::string toString() override;
            std::string toKey() override;
            TypePtr resolve() override;
            void unbind() override;

        private:
            InitializerType();
            InitializerPtr m_initializer;
    };
}
