#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics1D/Interactions/Mate.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/RelativeVelocity1DOutputTrait.h>
#include <openplx/Physics/Signals/FractionInputTrait.h>
#include <openplx/Physics/Signals/FractionOutputTrait.h>
#include <openplx/Physics/Signals/RelativeVelocity1DOutput.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
#include <openplx/Physics/Signals/FractionInput.h>
#include <openplx/Physics/Signals/FractionOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ManualBrake */
namespace openplx::DriveTrain {
    /**
     * Brake is a mechanism that applies a counter torque against a rotor,
     * gradually reducing its motion until it comes to a complete stop.
     *
     * A typical brake assembly consists of the caliper, brake pads, and hydraulically actuated pistons.
     * The pistons exert force on the brake pads, pressing them firmly against the rotating disk to generate
     * friction and slow down the rotor.
     *
     * A brake has an engagement and disengagement process. Note that the engagement fraction,
     * indicates the position of the brake pedal relative to the movement of the brake pads during braking operations.
     *
     * A value of 0 indicates that the brake is fully disengaged, meaning that the brake pedal is lifted up fully,
     * no braking torque is applied (free rotation). A value of 1 refers to a fully engaged brake, meaning that the
     * brake pedal is pressed down fully, full braking (maximum torque transfer) is applied.
     * During the engaging and disengaging process, the engagement fraction is varying within the range of [0,1].
     * This parameter simulates how much braking force is applied based on the pedal position.
     *
     * Note that the brake functions similarly to a Clutch, but in reverse. While a clutch engages when the pedal is fully released,
     * a brake engages when the pedal is fully pressed.
     *
     **/
    class OPENPLX_DriveTrain_BUNDLE_EXPORT ManualBrake : public openplx::Physics1D::Interactions::Mate, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::RelativeVelocity1DOutputTrait, public openplx::Physics::Signals::FractionInputTrait, public openplx::Physics::Signals::FractionOutputTrait {
        protected:
            double m_initial_engagement_fraction;
            double m_torque_capacity;
            double m_min_relative_slip_ratio;
            std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput> m_slip_velocity_output;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> m_engagement_fraction_input;
            std::shared_ptr<openplx::Physics::Signals::FractionOutput> m_engagement_fraction_output;

        public:
            ManualBrake();
            virtual ~ManualBrake();
            double initial_engagement_fraction() const;
            double torque_capacity() const;
            double min_relative_slip_ratio() const;
            std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput> slip_velocity_output() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> engagement_fraction_input() const;
            std::shared_ptr<openplx::Physics::Signals::FractionOutput> engagement_fraction_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
