#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/DriveTrain/Traits/RotationalPowerGenerator.h>
#include <openplx/Physics/Signals/FractionInputTrait.h>
#include <openplx/Physics/Signals/RpmOutputTrait.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/DriveTrain/RPMTorquePair.h>
#include <openplx/Physics/Signals/FractionInput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model EmpiricalEngine */
namespace openplx::DriveTrain {
    /**
     *     Empirical engine uses a torque curve to determine the maximum available torque for the current RPM.
     *
     *     'idle_rpm'          - Desired RPM when there is no throttle.
     *     'rpm_torque_list'   - The rpm - torque list.
     *     'initial_throttle'  - The initial_throttle is a value between 0-1, where 0 is no throttle, and 1 is max throttle.
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT EmpiricalEngine : public openplx::Physics::Interactions::Interaction1DOF, public openplx::DriveTrain::Traits::RotationalPowerGenerator, public openplx::Physics::Signals::FractionInputTrait, public openplx::Physics::Signals::RpmOutputTrait, public openplx::Physics::Signals::Torque1DOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::RpmOutput> m_rpm_output;
            double m_idle_rpm;
            std::vector<std::shared_ptr<openplx::DriveTrain::RPMTorquePair>> m_rpm_torque_list;
            std::shared_ptr<openplx::DriveTrain::RPMTorquePair> m_data_point1;
            std::shared_ptr<openplx::DriveTrain::RPMTorquePair> m_data_point2;
            std::shared_ptr<openplx::DriveTrain::RPMTorquePair> m_data_point3;
            double m_initial_throttle;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> m_throttle_input;

        public:
            EmpiricalEngine();
            virtual ~EmpiricalEngine();
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const override;
            std::shared_ptr<openplx::Physics::Signals::RpmOutput> rpm_output() const override;
            double idle_rpm() const;
            std::vector<std::shared_ptr<openplx::DriveTrain::RPMTorquePair>> rpm_torque_list() const;
            std::shared_ptr<openplx::DriveTrain::RPMTorquePair> data_point1() const;
            std::shared_ptr<openplx::DriveTrain::RPMTorquePair> data_point2() const;
            std::shared_ptr<openplx::DriveTrain::RPMTorquePair> data_point3() const;
            double initial_throttle() const;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> throttle_input() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
