%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Vehicles::FourWheel::FrontWheelDrive;
%nspace openplx::Vehicles::FourWheel::Traits::FrontLeftWheelSuspension;
%nspace openplx::Vehicles::FourWheel::Traits::FrontRightWheelSuspension;
%nspace openplx::Vehicles::FourWheel::Traits::RearLeftWheelSuspension;
%nspace openplx::Vehicles::FourWheel::Traits::RearRightWheelSuspension;
%nspace openplx::Vehicles::Steering::Interactions::Ackermann;
%nspace openplx::Vehicles::Steering::Interactions::BellCrank;
%nspace openplx::Vehicles::Steering::Interactions::DualSuspensionSteering;
%nspace openplx::Vehicles::Steering::Interactions::RackAndPinion;
%nspace openplx::Vehicles::Suspensions::Interactions::Connector;
%nspace openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate;
%nspace openplx::Vehicles::Suspensions::Interactions::Mate;
%nspace openplx::Vehicles::Suspensions::LinearSpringDamper;
%nspace openplx::Vehicles::Suspensions::SingleMateSuspension;
%nspace openplx::Vehicles::Suspensions::Suspension;
%nspace openplx::Vehicles::Suspensions::Traits::Steering;
%nspace openplx::Vehicles::Tracks::Belt;
%nspace openplx::Vehicles::Tracks::BoxLinkDescription;
%nspace openplx::Vehicles::Tracks::BoxLinkVariation;
%nspace openplx::Vehicles::Tracks::ContactGeometryLinkDescription;
%nspace openplx::Vehicles::Tracks::CyclicVariation;
%nspace openplx::Vehicles::Tracks::CylindricalIdler;
%nspace openplx::Vehicles::Tracks::CylindricalRoadWheel;
%nspace openplx::Vehicles::Tracks::CylindricalRoller;
%nspace openplx::Vehicles::Tracks::CylindricalSprocket;
%nspace openplx::Vehicles::Tracks::DefaultLinkDescription;
%nspace openplx::Vehicles::Tracks::DefaultLinkVariation;
%nspace openplx::Vehicles::Tracks::DiscretePulseVariation;
%nspace openplx::Vehicles::Tracks::FixedLinkCountBelt;
%nspace openplx::Vehicles::Tracks::IntertialRoadWheel;
%nspace openplx::Vehicles::Tracks::RigidCylindricalIdler;
%nspace openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody;
%nspace openplx::Vehicles::Tracks::RigidCylindricalRoller;
%nspace openplx::Vehicles::Tracks::RigidCylindricalSprocket;
%nspace openplx::Vehicles::Tracks::RoadWheel;
%nspace openplx::Vehicles::Tracks::SinusoidalVariation;
%nspace openplx::Vehicles::Tracks::System;
%nspace openplx::Vehicles::Vehicle;
%nspace openplx::Vehicles::Wheels::Actuator;
%nspace openplx::Vehicles::Wheels::ElasticWheel;
%nspace openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation;
%nspace openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping;
%nspace openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility;
%nspace openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility;
%nspace openplx::Vehicles::Wheels::Rim;
%nspace openplx::Vehicles::Wheels::RimTrait;
%nspace openplx::Vehicles::Wheels::Tire;
%nspace openplx::Vehicles::Wheels::TireTrait;
%nspace openplx::Vehicles::Wheels::Wheel;
%shared_ptr(openplx::Vehicles::FourWheel::FrontWheelDrive);
%shared_ptr(openplx::Vehicles::FourWheel::Traits::FrontLeftWheelSuspension);
%shared_ptr(openplx::Vehicles::FourWheel::Traits::FrontRightWheelSuspension);
%shared_ptr(openplx::Vehicles::FourWheel::Traits::RearLeftWheelSuspension);
%shared_ptr(openplx::Vehicles::FourWheel::Traits::RearRightWheelSuspension);
%shared_ptr(openplx::Vehicles::Steering::Interactions::Ackermann);
%shared_ptr(openplx::Vehicles::Steering::Interactions::BellCrank);
%shared_ptr(openplx::Vehicles::Steering::Interactions::DualSuspensionSteering);
%shared_ptr(openplx::Vehicles::Steering::Interactions::RackAndPinion);
%shared_ptr(openplx::Vehicles::Suspensions::Interactions::Connector);
%shared_ptr(openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate);
%shared_ptr(openplx::Vehicles::Suspensions::Interactions::Mate);
%shared_ptr(openplx::Vehicles::Suspensions::LinearSpringDamper);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMateSuspension);
%shared_ptr(openplx::Vehicles::Suspensions::Suspension);
%shared_ptr(openplx::Vehicles::Suspensions::Traits::Steering);
%shared_ptr(openplx::Vehicles::Tracks::Belt);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::ContactGeometryLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::CyclicVariation);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::DiscretePulseVariation);
%shared_ptr(openplx::Vehicles::Tracks::FixedLinkCountBelt);
%shared_ptr(openplx::Vehicles::Tracks::IntertialRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::RoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::SinusoidalVariation);
%shared_ptr(openplx::Vehicles::Tracks::System);
%shared_ptr(openplx::Vehicles::Vehicle);
%shared_ptr(openplx::Vehicles::Wheels::Actuator);
%shared_ptr(openplx::Vehicles::Wheels::ElasticWheel);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility);
%shared_ptr(openplx::Vehicles::Wheels::Rim);
%shared_ptr(openplx::Vehicles::Wheels::RimTrait);
%shared_ptr(openplx::Vehicles::Wheels::Tire);
%shared_ptr(openplx::Vehicles::Wheels::TireTrait);
%shared_ptr(openplx::Vehicles::Wheels::Wheel);
OPENPLX_TRAIT(FrontLeftWheelSuspension_TraitProxy, FrontLeftWheelSuspension, openplx::Vehicles::FourWheel::Traits::FrontLeftWheelSuspension);
OPENPLX_TRAIT(FrontRightWheelSuspension_TraitProxy, FrontRightWheelSuspension, openplx::Vehicles::FourWheel::Traits::FrontRightWheelSuspension);
OPENPLX_TRAIT(RearLeftWheelSuspension_TraitProxy, RearLeftWheelSuspension, openplx::Vehicles::FourWheel::Traits::RearLeftWheelSuspension);
OPENPLX_TRAIT(RearRightWheelSuspension_TraitProxy, RearRightWheelSuspension, openplx::Vehicles::FourWheel::Traits::RearRightWheelSuspension);
OPENPLX_TRAIT(Steering_TraitProxy, Steering, openplx::Vehicles::Suspensions::Traits::Steering);
OPENPLX_TRAIT(RimTrait_TraitProxy, RimTrait, openplx::Vehicles::Wheels::RimTrait);
OPENPLX_TRAIT(TireTrait_TraitProxy, TireTrait, openplx::Vehicles::Wheels::TireTrait);
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::FourWheel::FrontWheelDrive)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Interactions::Ackermann)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Interactions::BellCrank)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Interactions::DualSuspensionSteering)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Interactions::RackAndPinion)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::Interactions::Connector)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::Interactions::Mate)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::LinearSpringDamper)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::SingleMateSuspension)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::Suspension)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::Belt)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::BoxLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::BoxLinkVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::ContactGeometryLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CyclicVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalIdler)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalRoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalRoller)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalSprocket)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DefaultLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DefaultLinkVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DiscretePulseVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::FixedLinkCountBelt)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::IntertialRoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalIdler)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalRoller)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalSprocket)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::SinusoidalVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::System)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Vehicle)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Actuator)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::ElasticWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Rim)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Tire)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Wheel)
%typemap(csimports) openplx::Vehicles::Steering::Interactions::Ackermann "
/* Workaround for missing namespaces on interfaces */
using AngleInputTrait = openplx.Physics.Signals.AngleInputTrait;
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
";
%typemap(csimports) openplx::Vehicles::Steering::Interactions::BellCrank "
/* Workaround for missing namespaces on interfaces */
using AngleInputTrait = openplx.Physics.Signals.AngleInputTrait;
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
";
%typemap(csimports) openplx::Vehicles::Steering::Interactions::RackAndPinion "
/* Workaround for missing namespaces on interfaces */
using AngleInputTrait = openplx.Physics.Signals.AngleInputTrait;
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
";
%typemap(csimports) openplx::Vehicles::Wheels::Rim "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Vehicles::Wheels::Tire "
/* Workaround for missing namespaces on interfaces */
";
%include "openplx/Vehicles/Vehicle.h"
%include "openplx/Vehicles/FourWheel/FrontWheelDrive.h"
%include "openplx/Vehicles/FourWheel/Traits/FrontLeftWheelSuspension.h"
%include "openplx/Vehicles/FourWheel/Traits/FrontRightWheelSuspension.h"
%include "openplx/Vehicles/FourWheel/Traits/RearLeftWheelSuspension.h"
%include "openplx/Vehicles/FourWheel/Traits/RearRightWheelSuspension.h"
%include "openplx/Vehicles/Steering/Interactions/DualSuspensionSteering.h"
%include "openplx/Vehicles/Steering/Interactions/Ackermann.h"
%include "openplx/Vehicles/Steering/Interactions/BellCrank.h"
%include "openplx/Vehicles/Steering/Interactions/RackAndPinion.h"
%include "openplx/Vehicles/Suspensions/Interactions/Connector.h"
%include "openplx/Vehicles/Suspensions/Interactions/Mate.h"
%include "openplx/Vehicles/Suspensions/Interactions/LinearSpringDamperMate.h"
%include "openplx/Vehicles/Suspensions/Suspension.h"
%include "openplx/Vehicles/Suspensions/SingleMateSuspension.h"
%include "openplx/Vehicles/Suspensions/LinearSpringDamper.h"
%include "openplx/Vehicles/Suspensions/Traits/Steering.h"
%include "openplx/Vehicles/Tracks/Belt.h"
%include "openplx/Vehicles/Tracks/DefaultLinkDescription.h"
%include "openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h"
%include "openplx/Vehicles/Tracks/BoxLinkDescription.h"
%include "openplx/Vehicles/Tracks/DefaultLinkVariation.h"
%include "openplx/Vehicles/Tracks/BoxLinkVariation.h"
%include "openplx/Vehicles/Tracks/CyclicVariation.h"
%include "openplx/Vehicles/Tracks/RoadWheel.h"
%include "openplx/Vehicles/Tracks/IntertialRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalIdler.h"
%include "openplx/Vehicles/Tracks/CylindricalRoller.h"
%include "openplx/Vehicles/Tracks/CylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/DiscretePulseVariation.h"
%include "openplx/Vehicles/Tracks/FixedLinkCountBelt.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalIdler.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoller.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/SinusoidalVariation.h"
%include "openplx/Vehicles/Tracks/System.h"
%include "openplx/Vehicles/Wheels/Actuator.h"
%include "openplx/Vehicles/Wheels/Wheel.h"
%include "openplx/Vehicles/Wheels/ElasticWheel.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/DefaultWheelDissipation.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/WheelMechanicalDamping.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/DefaultWheelFlexibility.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/LinearElasticWheelFlexibility.h"
%include "openplx/Vehicles/Wheels/RimTrait.h"
%include "openplx/Vehicles/Wheels/Rim.h"
%include "openplx/Vehicles/Wheels/TireTrait.h"
%include "openplx/Vehicles/Wheels/Tire.h"
%ignore Vehicles_register_factories;
%include <openplx/Vehicles/Vehicles_all.h>
%inline {
    void Vehicles_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Vehicles_register_factories(eval_ctx);
    }
}
%template(VehiclesFourWheelFrontWheelDriveVector) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>>;
%template(VehiclesSteeringInteractionsAckermannVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>>;
%template(VehiclesSteeringInteractionsBellCrankVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>>;
%template(VehiclesSteeringInteractionsDualSuspensionSteeringVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering>>;
%template(VehiclesSteeringInteractionsRackAndPinionVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>>;
%template(VehiclesSuspensionsInteractionsConnectorVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector>>;
%template(VehiclesSuspensionsInteractionsLinearSpringDamperMateVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate>>;
%template(VehiclesSuspensionsInteractionsMateVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate>>;
%template(VehiclesSuspensionsLinearSpringDamperVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper>>;
%template(VehiclesSuspensionsSingleMateSuspensionVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>>;
%template(VehiclesSuspensionsSuspensionVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Suspension>>;
%template(VehiclesTracksBeltVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>;
%template(VehiclesTracksBoxLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>;
%template(VehiclesTracksBoxLinkVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>;
%template(VehiclesTracksContactGeometryLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>;
%template(VehiclesTracksCyclicVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>;
%template(VehiclesTracksCylindricalIdlerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>;
%template(VehiclesTracksCylindricalRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>;
%template(VehiclesTracksCylindricalRollerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>;
%template(VehiclesTracksCylindricalSprocketVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>;
%template(VehiclesTracksDefaultLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>;
%template(VehiclesTracksDefaultLinkVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>;
%template(VehiclesTracksDiscretePulseVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>;
%template(VehiclesTracksFixedLinkCountBeltVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>;
%template(VehiclesTracksIntertialRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>;
%template(VehiclesTracksRigidCylindricalIdlerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>;
%template(VehiclesTracksRigidCylindricalRoadWheelBodyVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>;
%template(VehiclesTracksRigidCylindricalRollerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>;
%template(VehiclesTracksRigidCylindricalSprocketVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>;
%template(VehiclesTracksRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>;
%template(VehiclesTracksSinusoidalVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>;
%template(VehiclesTracksSystemVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>;
%template(VehiclesVehicleVector) std::vector<std::shared_ptr<openplx::Vehicles::Vehicle>>;
%template(VehiclesWheelsActuatorVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Actuator>>;
%template(VehiclesWheelsElasticWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>>;
%template(VehiclesWheelsInteractionsDissipationDefaultWheelDissipationVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>>;
%template(VehiclesWheelsInteractionsDissipationWheelMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>>;
%template(VehiclesWheelsInteractionsFlexibilityDefaultWheelFlexibilityVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>>;
%template(VehiclesWheelsInteractionsFlexibilityLinearElasticWheelFlexibilityVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>>;
%template(VehiclesWheelsRimVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Rim>>;
%template(VehiclesWheelsTireVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Tire>>;
%template(VehiclesWheelsWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Wheel>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesFourWheelFrontWheelDrive, openplx::Vehicles::FourWheel::FrontWheelDrive)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringInteractionsAckermann, openplx::Vehicles::Steering::Interactions::Ackermann)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringInteractionsBellCrank, openplx::Vehicles::Steering::Interactions::BellCrank)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringInteractionsDualSuspensionSteering, openplx::Vehicles::Steering::Interactions::DualSuspensionSteering)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringInteractionsRackAndPinion, openplx::Vehicles::Steering::Interactions::RackAndPinion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsInteractionsConnector, openplx::Vehicles::Suspensions::Interactions::Connector)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsInteractionsLinearSpringDamperMate, openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsInteractionsMate, openplx::Vehicles::Suspensions::Interactions::Mate)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsLinearSpringDamper, openplx::Vehicles::Suspensions::LinearSpringDamper)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsSingleMateSuspension, openplx::Vehicles::Suspensions::SingleMateSuspension)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsSuspension, openplx::Vehicles::Suspensions::Suspension)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksBelt, openplx::Vehicles::Tracks::Belt)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksBoxLinkDescription, openplx::Vehicles::Tracks::BoxLinkDescription)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksBoxLinkVariation, openplx::Vehicles::Tracks::BoxLinkVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksContactGeometryLinkDescription, openplx::Vehicles::Tracks::ContactGeometryLinkDescription)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCyclicVariation, openplx::Vehicles::Tracks::CyclicVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCylindricalIdler, openplx::Vehicles::Tracks::CylindricalIdler)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCylindricalRoadWheel, openplx::Vehicles::Tracks::CylindricalRoadWheel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCylindricalRoller, openplx::Vehicles::Tracks::CylindricalRoller)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCylindricalSprocket, openplx::Vehicles::Tracks::CylindricalSprocket)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksDefaultLinkDescription, openplx::Vehicles::Tracks::DefaultLinkDescription)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksDefaultLinkVariation, openplx::Vehicles::Tracks::DefaultLinkVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksDiscretePulseVariation, openplx::Vehicles::Tracks::DiscretePulseVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksFixedLinkCountBelt, openplx::Vehicles::Tracks::FixedLinkCountBelt)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksIntertialRoadWheel, openplx::Vehicles::Tracks::IntertialRoadWheel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRigidCylindricalIdler, openplx::Vehicles::Tracks::RigidCylindricalIdler)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRigidCylindricalRoadWheelBody, openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRigidCylindricalRoller, openplx::Vehicles::Tracks::RigidCylindricalRoller)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRigidCylindricalSprocket, openplx::Vehicles::Tracks::RigidCylindricalSprocket)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRoadWheel, openplx::Vehicles::Tracks::RoadWheel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksSinusoidalVariation, openplx::Vehicles::Tracks::SinusoidalVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksSystem, openplx::Vehicles::Tracks::System)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesVehicle, openplx::Vehicles::Vehicle)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsActuator, openplx::Vehicles::Wheels::Actuator)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsElasticWheel, openplx::Vehicles::Wheels::ElasticWheel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsInteractionsDissipationDefaultWheelDissipation, openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsInteractionsDissipationWheelMechanicalDamping, openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsInteractionsFlexibilityDefaultWheelFlexibility, openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsInteractionsFlexibilityLinearElasticWheelFlexibility, openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsRim, openplx::Vehicles::Wheels::Rim)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsTire, openplx::Vehicles::Wheels::Tire)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsWheel, openplx::Vehicles::Wheels::Wheel)
