%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Physics3D::Bodies::Body;
%nspace openplx::Physics3D::Bodies::Inertia;
%nspace openplx::Physics3D::Bodies::Kinematics;
%nspace openplx::Physics3D::Bodies::RigidBody;
%nspace openplx::Physics3D::Bodies::RigidBodyKinematics;
%nspace openplx::Physics3D::Geometries::Box;
%nspace openplx::Physics3D::Geometries::Capsule;
%nspace openplx::Physics3D::Geometries::ContactGeometry;
%nspace openplx::Physics3D::Geometries::ConvexMesh;
%nspace openplx::Physics3D::Geometries::Cylinder;
%nspace openplx::Physics3D::Geometries::ExternalTriMeshGeometry;
%nspace openplx::Physics3D::Geometries::Sphere;
%nspace openplx::Physics3D::Geometries::TriMesh;
%nspace openplx::Physics3D::Geometries::TriMeshGeometry;
%nspace openplx::Physics3D::Interactions::AdaptiveMateConnector;
%nspace openplx::Physics3D::Interactions::Ball;
%nspace openplx::Physics3D::Interactions::Clearance::ConstantBallClearance;
%nspace openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance;
%nspace openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance;
%nspace openplx::Physics3D::Interactions::Clearance::ConstantLockClearance;
%nspace openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance;
%nspace openplx::Physics3D::Interactions::Clearance::DefaultMateClearance;
%nspace openplx::Physics3D::Interactions::Cylindrical;
%nspace openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping;
%nspace openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping;
%nspace openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation;
%nspace openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation;
%nspace openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation;
%nspace openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation;
%nspace openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation;
%nspace openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation;
%nspace openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation;
%nspace openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping;
%nspace openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping;
%nspace openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping;
%nspace openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping;
%nspace openplx::Physics3D::Interactions::Distance;
%nspace openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility;
%nspace openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility;
%nspace openplx::Physics3D::Interactions::ForceMotor;
%nspace openplx::Physics3D::Interactions::Hinge;
%nspace openplx::Physics3D::Interactions::LinearRange;
%nspace openplx::Physics3D::Interactions::LinearSpring;
%nspace openplx::Physics3D::Interactions::LinearVelocityMotor;
%nspace openplx::Physics3D::Interactions::Lock;
%nspace openplx::Physics3D::Interactions::Mate;
%nspace openplx::Physics3D::Interactions::MateConnector;
%nspace openplx::Physics3D::Interactions::Prismatic;
%nspace openplx::Physics3D::Interactions::RangeInteraction1DOF;
%nspace openplx::Physics3D::Interactions::RedirectedMateConnector;
%nspace openplx::Physics3D::Interactions::RotationalRange;
%nspace openplx::Physics3D::Interactions::RotationalVelocityMotor;
%nspace openplx::Physics3D::Interactions::SpringInteraction1DOF;
%nspace openplx::Physics3D::Interactions::StructuralPlanarConnector;
%nspace openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel;
%nspace openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel;
%nspace openplx::Physics3D::Interactions::SurfaceContact::Traits::BodyOrientedFriction;
%nspace openplx::Physics3D::Interactions::SurfaceContact::Traits::GeometryOrientedFriction;
%nspace openplx::Physics3D::Interactions::SurfaceContact::Traits::OrientedFriction;
%nspace openplx::Physics3D::Interactions::SurfaceContact::Traits::OrientedSurfaceViscosity;
%nspace openplx::Physics3D::Interactions::TorqueMotor;
%nspace openplx::Physics3D::Interactions::TorsionSpring;
%nspace openplx::Physics3D::Interactions::Toughness::BallThresholdFracture;
%nspace openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture;
%nspace openplx::Physics3D::Interactions::Toughness::DefaultBallToughness;
%nspace openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness;
%nspace openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness;
%nspace openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness;
%nspace openplx::Physics3D::Interactions::Toughness::DefaultLockToughness;
%nspace openplx::Physics3D::Interactions::Toughness::DefaultMateToughness;
%nspace openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness;
%nspace openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture;
%nspace openplx::Physics3D::Interactions::Toughness::LockThresholdFracture;
%nspace openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture;
%nspace openplx::Physics3D::Interactions::VelocityMotor;
%nspace openplx::Physics3D::Interactions::World;
%nspace openplx::Physics3D::Signals::AngularVelocity3DInput;
%nspace openplx::Physics3D::Signals::AngularVelocity3DInputTrait;
%nspace openplx::Physics3D::Signals::AngularVelocity3DOutput;
%nspace openplx::Physics3D::Signals::AngularVelocity3DOutputTrait;
%nspace openplx::Physics3D::Signals::Force3DOutput;
%nspace openplx::Physics3D::Signals::Force3DOutputTrait;
%nspace openplx::Physics3D::Signals::LinearVelocity3DInput;
%nspace openplx::Physics3D::Signals::LinearVelocity3DInputTrait;
%nspace openplx::Physics3D::Signals::LinearVelocity3DOutput;
%nspace openplx::Physics3D::Signals::LinearVelocity3DOutputTrait;
%nspace openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput;
%nspace openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput;
%nspace openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput;
%nspace openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput;
%nspace openplx::Physics3D::Signals::MateConnector::MCAngularVelocity3DOutputTrait;
%nspace openplx::Physics3D::Signals::MateConnector::MCLinearVelocity3DOutputTrait;
%nspace openplx::Physics3D::Signals::MateConnector::MateConnectorOutputTrait;
%nspace openplx::Physics3D::Signals::MateConnector::Output;
%nspace openplx::Physics3D::Signals::MateConnector::PositionOutput;
%nspace openplx::Physics3D::Signals::MateConnector::RPYOutput;
%nspace openplx::Physics3D::Signals::Position3DOutput;
%nspace openplx::Physics3D::Signals::Position3DOutputTrait;
%nspace openplx::Physics3D::Signals::RPYOutput;
%nspace openplx::Physics3D::Signals::RPYOutputTrait;
%nspace openplx::Physics3D::Signals::Torque3DInput;
%nspace openplx::Physics3D::Signals::Torque3DInputTrait;
%nspace openplx::Physics3D::Signals::Torque3DOutput;
%nspace openplx::Physics3D::Signals::Torque3DOutputTrait;
%nspace openplx::Physics3D::Signals::Vec3Marshalling;
%nspace openplx::Physics3D::StructuralComponent;
%nspace openplx::Physics3D::StructuralPlane;
%nspace openplx::Physics3D::System;
%shared_ptr(openplx::Physics3D::Bodies::Body);
%shared_ptr(openplx::Physics3D::Bodies::Inertia);
%shared_ptr(openplx::Physics3D::Bodies::Kinematics);
%shared_ptr(openplx::Physics3D::Bodies::RigidBody);
%shared_ptr(openplx::Physics3D::Bodies::RigidBodyKinematics);
%shared_ptr(openplx::Physics3D::Geometries::Box);
%shared_ptr(openplx::Physics3D::Geometries::Capsule);
%shared_ptr(openplx::Physics3D::Geometries::ContactGeometry);
%shared_ptr(openplx::Physics3D::Geometries::ConvexMesh);
%shared_ptr(openplx::Physics3D::Geometries::Cylinder);
%shared_ptr(openplx::Physics3D::Geometries::ExternalTriMeshGeometry);
%shared_ptr(openplx::Physics3D::Geometries::Sphere);
%shared_ptr(openplx::Physics3D::Geometries::TriMesh);
%shared_ptr(openplx::Physics3D::Geometries::TriMeshGeometry);
%shared_ptr(openplx::Physics3D::Interactions::AdaptiveMateConnector);
%shared_ptr(openplx::Physics3D::Interactions::Ball);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantBallClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantLockClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::DefaultMateClearance);
%shared_ptr(openplx::Physics3D::Interactions::Cylindrical);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Distance);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::ForceMotor);
%shared_ptr(openplx::Physics3D::Interactions::Hinge);
%shared_ptr(openplx::Physics3D::Interactions::LinearRange);
%shared_ptr(openplx::Physics3D::Interactions::LinearSpring);
%shared_ptr(openplx::Physics3D::Interactions::LinearVelocityMotor);
%shared_ptr(openplx::Physics3D::Interactions::Lock);
%shared_ptr(openplx::Physics3D::Interactions::Mate);
%shared_ptr(openplx::Physics3D::Interactions::MateConnector);
%shared_ptr(openplx::Physics3D::Interactions::Prismatic);
%shared_ptr(openplx::Physics3D::Interactions::RangeInteraction1DOF);
%shared_ptr(openplx::Physics3D::Interactions::RedirectedMateConnector);
%shared_ptr(openplx::Physics3D::Interactions::RotationalRange);
%shared_ptr(openplx::Physics3D::Interactions::RotationalVelocityMotor);
%shared_ptr(openplx::Physics3D::Interactions::SpringInteraction1DOF);
%shared_ptr(openplx::Physics3D::Interactions::StructuralPlanarConnector);
%shared_ptr(openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel);
%shared_ptr(openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel);
%shared_ptr(openplx::Physics3D::Interactions::SurfaceContact::Traits::BodyOrientedFriction);
%shared_ptr(openplx::Physics3D::Interactions::SurfaceContact::Traits::GeometryOrientedFriction);
%shared_ptr(openplx::Physics3D::Interactions::SurfaceContact::Traits::OrientedFriction);
%shared_ptr(openplx::Physics3D::Interactions::SurfaceContact::Traits::OrientedSurfaceViscosity);
%shared_ptr(openplx::Physics3D::Interactions::TorqueMotor);
%shared_ptr(openplx::Physics3D::Interactions::TorsionSpring);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::BallThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultBallToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultLockToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultMateToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::LockThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::VelocityMotor);
%shared_ptr(openplx::Physics3D::Interactions::World);
%shared_ptr(openplx::Physics3D::Signals::AngularVelocity3DInput);
%shared_ptr(openplx::Physics3D::Signals::AngularVelocity3DInputTrait);
%shared_ptr(openplx::Physics3D::Signals::AngularVelocity3DOutput);
%shared_ptr(openplx::Physics3D::Signals::AngularVelocity3DOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::Force3DOutput);
%shared_ptr(openplx::Physics3D::Signals::Force3DOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::LinearVelocity3DInput);
%shared_ptr(openplx::Physics3D::Signals::LinearVelocity3DInputTrait);
%shared_ptr(openplx::Physics3D::Signals::LinearVelocity3DOutput);
%shared_ptr(openplx::Physics3D::Signals::LinearVelocity3DOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::MCAngularVelocity3DOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::MCLinearVelocity3DOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::MateConnectorOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::Output);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::PositionOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::RPYOutput);
%shared_ptr(openplx::Physics3D::Signals::Position3DOutput);
%shared_ptr(openplx::Physics3D::Signals::Position3DOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::RPYOutput);
%shared_ptr(openplx::Physics3D::Signals::RPYOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::Torque3DInput);
%shared_ptr(openplx::Physics3D::Signals::Torque3DInputTrait);
%shared_ptr(openplx::Physics3D::Signals::Torque3DOutput);
%shared_ptr(openplx::Physics3D::Signals::Torque3DOutputTrait);
%shared_ptr(openplx::Physics3D::Signals::Vec3Marshalling);
%shared_ptr(openplx::Physics3D::StructuralComponent);
%shared_ptr(openplx::Physics3D::StructuralPlane);
%shared_ptr(openplx::Physics3D::System);
OPENPLX_TRAIT(BodyOrientedFriction_TraitProxy, BodyOrientedFriction, openplx::Physics3D::Interactions::SurfaceContact::Traits::BodyOrientedFriction);
OPENPLX_TRAIT(GeometryOrientedFriction_TraitProxy, GeometryOrientedFriction, openplx::Physics3D::Interactions::SurfaceContact::Traits::GeometryOrientedFriction);
OPENPLX_TRAIT(OrientedFriction_TraitProxy, OrientedFriction, openplx::Physics3D::Interactions::SurfaceContact::Traits::OrientedFriction);
OPENPLX_TRAIT(OrientedSurfaceViscosity_TraitProxy, OrientedSurfaceViscosity, openplx::Physics3D::Interactions::SurfaceContact::Traits::OrientedSurfaceViscosity);
OPENPLX_TRAIT(AngularVelocity3DInputTrait_TraitProxy, AngularVelocity3DInputTrait, openplx::Physics3D::Signals::AngularVelocity3DInputTrait);
OPENPLX_TRAIT(AngularVelocity3DOutputTrait_TraitProxy, AngularVelocity3DOutputTrait, openplx::Physics3D::Signals::AngularVelocity3DOutputTrait);
OPENPLX_TRAIT(Force3DOutputTrait_TraitProxy, Force3DOutputTrait, openplx::Physics3D::Signals::Force3DOutputTrait);
OPENPLX_TRAIT(LinearVelocity3DInputTrait_TraitProxy, LinearVelocity3DInputTrait, openplx::Physics3D::Signals::LinearVelocity3DInputTrait);
OPENPLX_TRAIT(LinearVelocity3DOutputTrait_TraitProxy, LinearVelocity3DOutputTrait, openplx::Physics3D::Signals::LinearVelocity3DOutputTrait);
OPENPLX_TRAIT(MCAngularVelocity3DOutputTrait_TraitProxy, MCAngularVelocity3DOutputTrait, openplx::Physics3D::Signals::MateConnector::MCAngularVelocity3DOutputTrait);
OPENPLX_TRAIT(MCLinearVelocity3DOutputTrait_TraitProxy, MCLinearVelocity3DOutputTrait, openplx::Physics3D::Signals::MateConnector::MCLinearVelocity3DOutputTrait);
OPENPLX_TRAIT(MateConnectorOutputTrait_TraitProxy, MateConnectorOutputTrait, openplx::Physics3D::Signals::MateConnector::MateConnectorOutputTrait);
OPENPLX_TRAIT(Position3DOutputTrait_TraitProxy, Position3DOutputTrait, openplx::Physics3D::Signals::Position3DOutputTrait);
OPENPLX_TRAIT(RPYOutputTrait_TraitProxy, RPYOutputTrait, openplx::Physics3D::Signals::RPYOutputTrait);
OPENPLX_TRAIT(Torque3DInputTrait_TraitProxy, Torque3DInputTrait, openplx::Physics3D::Signals::Torque3DInputTrait);
OPENPLX_TRAIT(Torque3DOutputTrait_TraitProxy, Torque3DOutputTrait, openplx::Physics3D::Signals::Torque3DOutputTrait);
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Bodies::Body)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Bodies::Inertia)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Bodies::Kinematics)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Bodies::RigidBody)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Bodies::RigidBodyKinematics)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::Box)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::Capsule)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::ContactGeometry)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::ConvexMesh)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::Cylinder)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::ExternalTriMeshGeometry)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::Sphere)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::TriMesh)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Geometries::TriMeshGeometry)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::AdaptiveMateConnector)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Ball)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Clearance::ConstantBallClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Clearance::ConstantLockClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Clearance::DefaultMateClearance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Cylindrical)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Distance)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::ForceMotor)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Hinge)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::LinearRange)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::LinearSpring)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::LinearVelocityMotor)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Lock)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Mate)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::MateConnector)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Prismatic)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::RangeInteraction1DOF)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::RedirectedMateConnector)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::RotationalRange)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::RotationalVelocityMotor)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::SpringInteraction1DOF)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::StructuralPlanarConnector)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::TorqueMotor)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::TorsionSpring)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::BallThresholdFracture)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::DefaultBallToughness)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::DefaultLockToughness)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::DefaultMateToughness)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::LockThresholdFracture)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::VelocityMotor)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Interactions::World)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::AngularVelocity3DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::AngularVelocity3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::Force3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::LinearVelocity3DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::LinearVelocity3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::MateConnector::Output)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::MateConnector::PositionOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::MateConnector::RPYOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::Position3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::RPYOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::Torque3DInput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::Torque3DOutput)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::Signals::Vec3Marshalling)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::StructuralComponent)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::StructuralPlane)
OPENPLX_FIX_DOWNCASTING(openplx::Physics3D::System)
%typemap(csimports) openplx::Physics3D::Bodies::RigidBody "
/* Workaround for missing namespaces on interfaces */
using LinearVelocity3DInputTrait = openplx.Physics3D.Signals.LinearVelocity3DInputTrait;
using AngularVelocity3DInputTrait = openplx.Physics3D.Signals.AngularVelocity3DInputTrait;
using LinearVelocity3DOutputTrait = openplx.Physics3D.Signals.LinearVelocity3DOutputTrait;
using AngularVelocity3DOutputTrait = openplx.Physics3D.Signals.AngularVelocity3DOutputTrait;
using Position3DOutputTrait = openplx.Physics3D.Signals.Position3DOutputTrait;
using RPYOutputTrait = openplx.Physics3D.Signals.RPYOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::Ball "
/* Workaround for missing namespaces on interfaces */
using Force3DOutputTrait = openplx.Physics3D.Signals.Force3DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::Cylindrical "
/* Workaround for missing namespaces on interfaces */
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
using AngularVelocity1DOutputTrait = openplx.Physics.Signals.AngularVelocity1DOutputTrait;
using Position1DOutputTrait = openplx.Physics.Signals.Position1DOutputTrait;
using LinearVelocity1DOutputTrait = openplx.Physics.Signals.LinearVelocity1DOutputTrait;
using Force3DOutputTrait = openplx.Physics3D.Signals.Force3DOutputTrait;
using Torque3DOutputTrait = openplx.Physics3D.Signals.Torque3DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::Distance "
/* Workaround for missing namespaces on interfaces */
using Position1DOutputTrait = openplx.Physics.Signals.Position1DOutputTrait;
using Position1DInputTrait = openplx.Physics.Signals.Position1DInputTrait;
using Force1DOutputTrait = openplx.Physics.Signals.Force1DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::ForceMotor "
/* Workaround for missing namespaces on interfaces */
using Force1DInputTrait = openplx.Physics.Signals.Force1DInputTrait;
using Force1DOutputTrait = openplx.Physics.Signals.Force1DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::Hinge "
/* Workaround for missing namespaces on interfaces */
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
using AngularVelocity1DOutputTrait = openplx.Physics.Signals.AngularVelocity1DOutputTrait;
using Force3DOutputTrait = openplx.Physics3D.Signals.Force3DOutputTrait;
using Torque3DOutputTrait = openplx.Physics3D.Signals.Torque3DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::LinearRange "
/* Workaround for missing namespaces on interfaces */
using Force1DOutputTrait = openplx.Physics.Signals.Force1DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::LinearSpring "
/* Workaround for missing namespaces on interfaces */
using Force1DOutputTrait = openplx.Physics.Signals.Force1DOutputTrait;
using Position1DOutputTrait = openplx.Physics.Signals.Position1DOutputTrait;
using Position1DInputTrait = openplx.Physics.Signals.Position1DInputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::LinearVelocityMotor "
/* Workaround for missing namespaces on interfaces */
using Force1DOutputTrait = openplx.Physics.Signals.Force1DOutputTrait;
using LinearVelocity1DOutputTrait = openplx.Physics.Signals.LinearVelocity1DOutputTrait;
using LinearVelocity1DInputTrait = openplx.Physics.Signals.LinearVelocity1DInputTrait;
using ForceRangeInputTrait = openplx.Physics.Signals.ForceRangeInputTrait;
using ForceRangeOutputTrait = openplx.Physics.Signals.ForceRangeOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::Lock "
/* Workaround for missing namespaces on interfaces */
using Force3DOutputTrait = openplx.Physics3D.Signals.Force3DOutputTrait;
using Torque3DOutputTrait = openplx.Physics3D.Signals.Torque3DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::MateConnector "
/* Workaround for missing namespaces on interfaces */
using LinearVelocity3DOutputTrait = openplx.Physics3D.Signals.LinearVelocity3DOutputTrait;
using MCLinearVelocity3DOutputTrait = openplx.Physics3D.Signals.MateConnector.MCLinearVelocity3DOutputTrait;
using AngularVelocity3DOutputTrait = openplx.Physics3D.Signals.AngularVelocity3DOutputTrait;
using MCAngularVelocity3DOutputTrait = openplx.Physics3D.Signals.MateConnector.MCAngularVelocity3DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::Prismatic "
/* Workaround for missing namespaces on interfaces */
using Position1DOutputTrait = openplx.Physics.Signals.Position1DOutputTrait;
using LinearVelocity1DOutputTrait = openplx.Physics.Signals.LinearVelocity1DOutputTrait;
using Force3DOutputTrait = openplx.Physics3D.Signals.Force3DOutputTrait;
using Torque3DOutputTrait = openplx.Physics3D.Signals.Torque3DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::RotationalRange "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::RotationalVelocityMotor "
/* Workaround for missing namespaces on interfaces */
using AngularVelocity1DInputTrait = openplx.Physics.Signals.AngularVelocity1DInputTrait;
using AngularVelocity1DOutputTrait = openplx.Physics.Signals.AngularVelocity1DOutputTrait;
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using TorqueRangeInputTrait = openplx.Physics.Signals.TorqueRangeInputTrait;
using TorqueRangeOutputTrait = openplx.Physics.Signals.TorqueRangeOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::SurfaceContact::Traits::BodyOrientedFriction "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Physics3D::Interactions::SurfaceContact::Traits::GeometryOrientedFriction "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Physics3D::Interactions::SurfaceContact::Traits::OrientedSurfaceViscosity "
/* Workaround for missing namespaces on interfaces */
using SurfaceViscosity = openplx.Physics.Interactions.SurfaceContact.Traits.SurfaceViscosity;
";
%typemap(csimports) openplx::Physics3D::Interactions::TorqueMotor "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using Torque1DInputTrait = openplx.Physics.Signals.Torque1DInputTrait;
";
%typemap(csimports) openplx::Physics3D::Interactions::TorsionSpring "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
using AngleInputTrait = openplx.Physics.Signals.AngleInputTrait;
";
%typemap(csimports) openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Physics3D::Signals::MateConnector::MCAngularVelocity3DOutputTrait "
/* Workaround for missing namespaces on interfaces */
using AngularVelocity3DOutputTrait = openplx.Physics3D.Signals.AngularVelocity3DOutputTrait;
";
%typemap(csimports) openplx::Physics3D::Signals::MateConnector::MCLinearVelocity3DOutputTrait "
/* Workaround for missing namespaces on interfaces */
using LinearVelocity3DOutputTrait = openplx.Physics3D.Signals.LinearVelocity3DOutputTrait;
";
%include "openplx/Physics3D/Bodies/Body.h"
%include "openplx/Physics3D/Bodies/Inertia.h"
%include "openplx/Physics3D/Bodies/Kinematics.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DInputTrait.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DInputTrait.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DOutputTrait.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DOutputTrait.h"
%include "openplx/Physics3D/Signals/Position3DOutputTrait.h"
%include "openplx/Physics3D/Signals/RPYOutputTrait.h"
%include "openplx/Physics3D/Bodies/RigidBody.h"
%include "openplx/Physics3D/Bodies/RigidBodyKinematics.h"
%include "openplx/Physics3D/Geometries/ContactGeometry.h"
%include "openplx/Physics3D/Geometries/Box.h"
%include "openplx/Physics3D/Geometries/Capsule.h"
%include "openplx/Physics3D/Geometries/TriMeshGeometry.h"
%include "openplx/Physics3D/Geometries/ConvexMesh.h"
%include "openplx/Physics3D/Geometries/Cylinder.h"
%include "openplx/Physics3D/Geometries/ExternalTriMeshGeometry.h"
%include "openplx/Physics3D/Geometries/Sphere.h"
%include "openplx/Physics3D/Geometries/TriMesh.h"
%include "openplx/Physics3D/Signals/MateConnector/MCLinearVelocity3DOutputTrait.h"
%include "openplx/Physics3D/Signals/MateConnector/MCAngularVelocity3DOutputTrait.h"
%include "openplx/Physics3D/Interactions/MateConnector.h"
%include "openplx/Physics3D/Interactions/AdaptiveMateConnector.h"
%include "openplx/Physics3D/Interactions/Mate.h"
%include "openplx/Physics3D/Signals/Force3DOutputTrait.h"
%include "openplx/Physics3D/Interactions/Ball.h"
%include "openplx/Physics3D/Interactions/Clearance/DefaultMateClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantBallClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantCylindricalClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantHingeClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantLockClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantPrismaticClearance.h"
%include "openplx/Physics3D/Signals/Torque3DOutputTrait.h"
%include "openplx/Physics3D/Interactions/Cylindrical.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultMateDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultBallDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/BallMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultCylindricalDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/CylindricalMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultDistanceDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultHingeDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultLockDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultPrismaticDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DistanceMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/HingeMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/LockMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/PrismaticMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Distance.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultMateFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultBallFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultCylindricalFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultDistanceFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultHingeFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultLockFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultPrismaticFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticBallFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticCylindricalFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticDistanceFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticHingeFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticLockFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticPrismaticFlexibility.h"
%include "openplx/Physics3D/Interactions/ForceMotor.h"
%include "openplx/Physics3D/Interactions/Hinge.h"
%include "openplx/Physics3D/Interactions/RangeInteraction1DOF.h"
%include "openplx/Physics3D/Interactions/LinearRange.h"
%include "openplx/Physics3D/Interactions/SpringInteraction1DOF.h"
%include "openplx/Physics3D/Interactions/LinearSpring.h"
%include "openplx/Physics3D/Interactions/VelocityMotor.h"
%include "openplx/Physics3D/Interactions/LinearVelocityMotor.h"
%include "openplx/Physics3D/Interactions/Lock.h"
%include "openplx/Physics3D/Interactions/Prismatic.h"
%include "openplx/Physics3D/Interactions/RedirectedMateConnector.h"
%include "openplx/Physics3D/Interactions/RotationalRange.h"
%include "openplx/Physics3D/Interactions/RotationalVelocityMotor.h"
%include "openplx/Physics3D/Interactions/StructuralPlanarConnector.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/PatchElasticityDryFrictionModel.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/PointwiseElasticityDryFrictionModel.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/Traits/OrientedFriction.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/Traits/BodyOrientedFriction.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/Traits/GeometryOrientedFriction.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/Traits/OrientedSurfaceViscosity.h"
%include "openplx/Physics3D/Interactions/TorqueMotor.h"
%include "openplx/Physics3D/Interactions/TorsionSpring.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultMateToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultBallToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/BallThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultCylindricalToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/CylindricalThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultDistanceThoughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultHingeToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultLockToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultPrismaticToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/HingeThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/LockThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/PrismaticThresholdFracture.h"
%include "openplx/Physics3D/Interactions/World.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DInput.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/Force3DOutput.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DInput.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/Output.h"
%include "openplx/Physics3D/Signals/MateConnector/Acceleration3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/AngularAcceleration3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/MateConnectorOutputTrait.h"
%include "openplx/Physics3D/Signals/MateConnector/AngularVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/LinearVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/PositionOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/RPYOutput.h"
%include "openplx/Physics3D/Signals/Position3DOutput.h"
%include "openplx/Physics3D/Signals/RPYOutput.h"
%include "openplx/Physics3D/Signals/Torque3DInput.h"
%include "openplx/Physics3D/Signals/Torque3DInputTrait.h"
%include "openplx/Physics3D/Signals/Torque3DOutput.h"
%include "openplx/Physics3D/Signals/Vec3Marshalling.h"
%include "openplx/Physics3D/System.h"
%include "openplx/Physics3D/StructuralComponent.h"
%include "openplx/Physics3D/StructuralPlane.h"
%ignore Physics3D_register_factories;
%include <openplx/Physics3D/Physics3D_all.h>
%inline {
    void Physics3D_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Physics3D_register_factories(eval_ctx);
    }
}
%template(Physics3DBodiesBodyVector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Body>>;
%template(Physics3DBodiesInertiaVector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Inertia>>;
%template(Physics3DBodiesKinematicsVector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Kinematics>>;
%template(Physics3DBodiesRigidBodyVector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>>;
%template(Physics3DBodiesRigidBodyKinematicsVector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics>>;
%template(Physics3DGeometriesBoxVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Box>>;
%template(Physics3DGeometriesCapsuleVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Capsule>>;
%template(Physics3DGeometriesContactGeometryVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry>>;
%template(Physics3DGeometriesConvexMeshVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh>>;
%template(Physics3DGeometriesCylinderVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Cylinder>>;
%template(Physics3DGeometriesExternalTriMeshGeometryVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry>>;
%template(Physics3DGeometriesSphereVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Sphere>>;
%template(Physics3DGeometriesTriMeshVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::TriMesh>>;
%template(Physics3DGeometriesTriMeshGeometryVector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry>>;
%template(Physics3DInteractionsAdaptiveMateConnectorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector>>;
%template(Physics3DInteractionsBallVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Ball>>;
%template(Physics3DInteractionsClearanceConstantBallClearanceVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance>>;
%template(Physics3DInteractionsClearanceConstantCylindricalClearanceVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance>>;
%template(Physics3DInteractionsClearanceConstantHingeClearanceVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance>>;
%template(Physics3DInteractionsClearanceConstantLockClearanceVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance>>;
%template(Physics3DInteractionsClearanceConstantPrismaticClearanceVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance>>;
%template(Physics3DInteractionsClearanceDefaultMateClearanceVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance>>;
%template(Physics3DInteractionsCylindricalVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical>>;
%template(Physics3DInteractionsDissipationBallMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping>>;
%template(Physics3DInteractionsDissipationCylindricalMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping>>;
%template(Physics3DInteractionsDissipationDefaultBallDissipationVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation>>;
%template(Physics3DInteractionsDissipationDefaultCylindricalDissipationVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation>>;
%template(Physics3DInteractionsDissipationDefaultDistanceDissipationVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation>>;
%template(Physics3DInteractionsDissipationDefaultHingeDissipationVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation>>;
%template(Physics3DInteractionsDissipationDefaultLockDissipationVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation>>;
%template(Physics3DInteractionsDissipationDefaultMateDissipationVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation>>;
%template(Physics3DInteractionsDissipationDefaultPrismaticDissipationVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation>>;
%template(Physics3DInteractionsDissipationDistanceMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping>>;
%template(Physics3DInteractionsDissipationHingeMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping>>;
%template(Physics3DInteractionsDissipationLockMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping>>;
%template(Physics3DInteractionsDissipationPrismaticMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping>>;
%template(Physics3DInteractionsDistanceVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Distance>>;
%template(Physics3DInteractionsFlexibilityDefaultBallFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility>>;
%template(Physics3DInteractionsFlexibilityDefaultCylindricalFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility>>;
%template(Physics3DInteractionsFlexibilityDefaultDistanceFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility>>;
%template(Physics3DInteractionsFlexibilityDefaultHingeFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility>>;
%template(Physics3DInteractionsFlexibilityDefaultLockFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility>>;
%template(Physics3DInteractionsFlexibilityDefaultMateFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility>>;
%template(Physics3DInteractionsFlexibilityDefaultPrismaticFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility>>;
%template(Physics3DInteractionsFlexibilityLinearElasticBallFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility>>;
%template(Physics3DInteractionsFlexibilityLinearElasticCylindricalFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility>>;
%template(Physics3DInteractionsFlexibilityLinearElasticDistanceFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility>>;
%template(Physics3DInteractionsFlexibilityLinearElasticHingeFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility>>;
%template(Physics3DInteractionsFlexibilityLinearElasticLockFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility>>;
%template(Physics3DInteractionsFlexibilityLinearElasticPrismaticFlexibilityVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility>>;
%template(Physics3DInteractionsForceMotorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor>>;
%template(Physics3DInteractionsHingeVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Hinge>>;
%template(Physics3DInteractionsLinearRangeVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearRange>>;
%template(Physics3DInteractionsLinearSpringVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring>>;
%template(Physics3DInteractionsLinearVelocityMotorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor>>;
%template(Physics3DInteractionsLockVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Lock>>;
%template(Physics3DInteractionsMateVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Mate>>;
%template(Physics3DInteractionsMateConnectorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>>;
%template(Physics3DInteractionsPrismaticVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Prismatic>>;
%template(Physics3DInteractionsRangeInteraction1DOFVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF>>;
%template(Physics3DInteractionsRedirectedMateConnectorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector>>;
%template(Physics3DInteractionsRotationalRangeVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange>>;
%template(Physics3DInteractionsRotationalVelocityMotorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor>>;
%template(Physics3DInteractionsSpringInteraction1DOFVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF>>;
%template(Physics3DInteractionsStructuralPlanarConnectorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector>>;
%template(Physics3DInteractionsSurfaceContactPatchElasticityDryFrictionModelVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel>>;
%template(Physics3DInteractionsSurfaceContactPointwiseElasticityDryFrictionModelVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel>>;
%template(Physics3DInteractionsTorqueMotorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor>>;
%template(Physics3DInteractionsTorsionSpringVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring>>;
%template(Physics3DInteractionsToughnessBallThresholdFractureVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture>>;
%template(Physics3DInteractionsToughnessCylindricalThresholdFractureVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture>>;
%template(Physics3DInteractionsToughnessDefaultBallToughnessVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness>>;
%template(Physics3DInteractionsToughnessDefaultCylindricalToughnessVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness>>;
%template(Physics3DInteractionsToughnessDefaultDistanceThoughnessVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness>>;
%template(Physics3DInteractionsToughnessDefaultHingeToughnessVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness>>;
%template(Physics3DInteractionsToughnessDefaultLockToughnessVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness>>;
%template(Physics3DInteractionsToughnessDefaultMateToughnessVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness>>;
%template(Physics3DInteractionsToughnessDefaultPrismaticToughnessVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness>>;
%template(Physics3DInteractionsToughnessHingeThresholdFractureVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture>>;
%template(Physics3DInteractionsToughnessLockThresholdFractureVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture>>;
%template(Physics3DInteractionsToughnessPrismaticThresholdFractureVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture>>;
%template(Physics3DInteractionsVelocityMotorVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor>>;
%template(Physics3DInteractionsWorldVector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::World>>;
%template(Physics3DSignalsAngularVelocity3DInputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput>>;
%template(Physics3DSignalsAngularVelocity3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput>>;
%template(Physics3DSignalsForce3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput>>;
%template(Physics3DSignalsLinearVelocity3DInputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput>>;
%template(Physics3DSignalsLinearVelocity3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput>>;
%template(Physics3DSignalsMateConnectorAcceleration3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput>>;
%template(Physics3DSignalsMateConnectorAngularAcceleration3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput>>;
%template(Physics3DSignalsMateConnectorAngularVelocity3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput>>;
%template(Physics3DSignalsMateConnectorLinearVelocity3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput>>;
%template(Physics3DSignalsMateConnectorOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output>>;
%template(Physics3DSignalsMateConnectorPositionOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput>>;
%template(Physics3DSignalsMateConnectorRPYOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput>>;
%template(Physics3DSignalsPosition3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput>>;
%template(Physics3DSignalsRPYOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::RPYOutput>>;
%template(Physics3DSignalsTorque3DInputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput>>;
%template(Physics3DSignalsTorque3DOutputVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput>>;
%template(Physics3DSignalsVec3MarshallingVector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling>>;
%template(Physics3DStructuralComponentVector) std::vector<std::shared_ptr<openplx::Physics3D::StructuralComponent>>;
%template(Physics3DStructuralPlaneVector) std::vector<std::shared_ptr<openplx::Physics3D::StructuralPlane>>;
%template(Physics3DSystemVector) std::vector<std::shared_ptr<openplx::Physics3D::System>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DBodiesBody, openplx::Physics3D::Bodies::Body)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DBodiesInertia, openplx::Physics3D::Bodies::Inertia)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DBodiesKinematics, openplx::Physics3D::Bodies::Kinematics)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DBodiesRigidBody, openplx::Physics3D::Bodies::RigidBody)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DBodiesRigidBodyKinematics, openplx::Physics3D::Bodies::RigidBodyKinematics)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesBox, openplx::Physics3D::Geometries::Box)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesCapsule, openplx::Physics3D::Geometries::Capsule)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesContactGeometry, openplx::Physics3D::Geometries::ContactGeometry)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesConvexMesh, openplx::Physics3D::Geometries::ConvexMesh)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesCylinder, openplx::Physics3D::Geometries::Cylinder)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesExternalTriMeshGeometry, openplx::Physics3D::Geometries::ExternalTriMeshGeometry)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesSphere, openplx::Physics3D::Geometries::Sphere)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesTriMesh, openplx::Physics3D::Geometries::TriMesh)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DGeometriesTriMeshGeometry, openplx::Physics3D::Geometries::TriMeshGeometry)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsAdaptiveMateConnector, openplx::Physics3D::Interactions::AdaptiveMateConnector)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsBall, openplx::Physics3D::Interactions::Ball)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsClearanceConstantBallClearance, openplx::Physics3D::Interactions::Clearance::ConstantBallClearance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsClearanceConstantCylindricalClearance, openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsClearanceConstantHingeClearance, openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsClearanceConstantLockClearance, openplx::Physics3D::Interactions::Clearance::ConstantLockClearance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsClearanceConstantPrismaticClearance, openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsClearanceDefaultMateClearance, openplx::Physics3D::Interactions::Clearance::DefaultMateClearance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsCylindrical, openplx::Physics3D::Interactions::Cylindrical)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationBallMechanicalDamping, openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationCylindricalMechanicalDamping, openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationDefaultBallDissipation, openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationDefaultCylindricalDissipation, openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationDefaultDistanceDissipation, openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationDefaultHingeDissipation, openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationDefaultLockDissipation, openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationDefaultMateDissipation, openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationDefaultPrismaticDissipation, openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationDistanceMechanicalDamping, openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationHingeMechanicalDamping, openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationLockMechanicalDamping, openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDissipationPrismaticMechanicalDamping, openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsDistance, openplx::Physics3D::Interactions::Distance)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityDefaultBallFlexibility, openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityDefaultCylindricalFlexibility, openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityDefaultDistanceFlexibility, openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityDefaultHingeFlexibility, openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityDefaultLockFlexibility, openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityDefaultMateFlexibility, openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityDefaultPrismaticFlexibility, openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityLinearElasticBallFlexibility, openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityLinearElasticCylindricalFlexibility, openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityLinearElasticDistanceFlexibility, openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityLinearElasticHingeFlexibility, openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityLinearElasticLockFlexibility, openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsFlexibilityLinearElasticPrismaticFlexibility, openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsForceMotor, openplx::Physics3D::Interactions::ForceMotor)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsHinge, openplx::Physics3D::Interactions::Hinge)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsLinearRange, openplx::Physics3D::Interactions::LinearRange)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsLinearSpring, openplx::Physics3D::Interactions::LinearSpring)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsLinearVelocityMotor, openplx::Physics3D::Interactions::LinearVelocityMotor)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsLock, openplx::Physics3D::Interactions::Lock)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsMate, openplx::Physics3D::Interactions::Mate)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsMateConnector, openplx::Physics3D::Interactions::MateConnector)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsPrismatic, openplx::Physics3D::Interactions::Prismatic)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsRangeInteraction1DOF, openplx::Physics3D::Interactions::RangeInteraction1DOF)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsRedirectedMateConnector, openplx::Physics3D::Interactions::RedirectedMateConnector)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsRotationalRange, openplx::Physics3D::Interactions::RotationalRange)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsRotationalVelocityMotor, openplx::Physics3D::Interactions::RotationalVelocityMotor)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsSpringInteraction1DOF, openplx::Physics3D::Interactions::SpringInteraction1DOF)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsStructuralPlanarConnector, openplx::Physics3D::Interactions::StructuralPlanarConnector)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsSurfaceContactPatchElasticityDryFrictionModel, openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsSurfaceContactPointwiseElasticityDryFrictionModel, openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsTorqueMotor, openplx::Physics3D::Interactions::TorqueMotor)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsTorsionSpring, openplx::Physics3D::Interactions::TorsionSpring)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessBallThresholdFracture, openplx::Physics3D::Interactions::Toughness::BallThresholdFracture)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessCylindricalThresholdFracture, openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessDefaultBallToughness, openplx::Physics3D::Interactions::Toughness::DefaultBallToughness)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessDefaultCylindricalToughness, openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessDefaultDistanceThoughness, openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessDefaultHingeToughness, openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessDefaultLockToughness, openplx::Physics3D::Interactions::Toughness::DefaultLockToughness)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessDefaultMateToughness, openplx::Physics3D::Interactions::Toughness::DefaultMateToughness)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessDefaultPrismaticToughness, openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessHingeThresholdFracture, openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessLockThresholdFracture, openplx::Physics3D::Interactions::Toughness::LockThresholdFracture)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsToughnessPrismaticThresholdFracture, openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsVelocityMotor, openplx::Physics3D::Interactions::VelocityMotor)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DInteractionsWorld, openplx::Physics3D::Interactions::World)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsAngularVelocity3DInput, openplx::Physics3D::Signals::AngularVelocity3DInput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsAngularVelocity3DOutput, openplx::Physics3D::Signals::AngularVelocity3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsForce3DOutput, openplx::Physics3D::Signals::Force3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsLinearVelocity3DInput, openplx::Physics3D::Signals::LinearVelocity3DInput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsLinearVelocity3DOutput, openplx::Physics3D::Signals::LinearVelocity3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsMateConnectorAcceleration3DOutput, openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsMateConnectorAngularAcceleration3DOutput, openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsMateConnectorAngularVelocity3DOutput, openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsMateConnectorLinearVelocity3DOutput, openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsMateConnectorOutput, openplx::Physics3D::Signals::MateConnector::Output)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsMateConnectorPositionOutput, openplx::Physics3D::Signals::MateConnector::PositionOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsMateConnectorRPYOutput, openplx::Physics3D::Signals::MateConnector::RPYOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsPosition3DOutput, openplx::Physics3D::Signals::Position3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsRPYOutput, openplx::Physics3D::Signals::RPYOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsTorque3DInput, openplx::Physics3D::Signals::Torque3DInput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsTorque3DOutput, openplx::Physics3D::Signals::Torque3DOutput)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSignalsVec3Marshalling, openplx::Physics3D::Signals::Vec3Marshalling)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DStructuralComponent, openplx::Physics3D::StructuralComponent)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DStructuralPlane, openplx::Physics3D::StructuralPlane)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalPhysics3DSystem, openplx::Physics3D::System)
