/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxSensor/LidarRayPatternGenerator.h>

namespace agxSensor
{
  /**
  Ray pattern with only one single ray along the local z-axis of the Lidar using it.
  */
  class AGXSENSOR_EXPORT LidarRayPatternSingleRay : public LidarRayPatternGenerator
  {
    public:
      LidarRayPatternSingleRay();

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      virtual LidarRayPatternInterval getNextInterval(agx::Real dt) override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::LidarRayPatternSingleRay );

      DOXYGEN_END_INTERNAL_BLOCK()
  };
}
