/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/MagnetometerModel.h>
#include <agxSensor/IMUModelSensorAttachment.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( IMUModelMagnetometerAttachment );

  /**
  Magnetometer sensor attachment onto an IMU model.
  */
  class AGXSENSOR_EXPORT IMUModelMagnetometerAttachment : public IMUModelSensorAttachment
  {
    public:
      /**
      Construct an IMU model attachment for a magnetometer.
      \param transform - relative transform of the magnetometer on the IMU
      \param model - model defining the parameters of the magnetometer instance, invalid if
                     nullptr
      */
      IMUModelMagnetometerAttachment( const agx::AffineMatrix4x4& transform,
                                      MagnetometerModel* model );

      /**
      \return relative transform of the magnetometer on the IMU
      */
      const agx::AffineMatrix4x4& getTransform() const;

      /**
      \return the model of the magnetometer
      */
      MagnetometerModel* getModel() const;

      /**
      \return a new instance of the sensor placed in an attachment specification
      */
      virtual SensorAttachment instantiateSensor() const override;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      IMUModelMagnetometerAttachment();

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::IMUModelMagnetometerAttachment );

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      agx::AffineMatrix4x4 m_transform;
      MagnetometerModelRef m_model;
  };
}
