/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <memory>
#include <openplx/Physics3D/Interactions/MateConnector.h>

namespace agxopenplx
{

  inline bool isWorld(const std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>& mc_position_output)
  {
    // NOTE: Would like to check against a World instance - but not possible with current API
    return mc_position_output->getName() == "Physics3D.Interactions.World" && mc_position_output->getOwner() == nullptr;
  }
}
