/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxOSG/export.h>

#include <memory>

namespace osg
{
  class Group;
}

namespace agxopenplx {

  class OpenPlxToAgxVisualsMapper;
  class OpenPlxSensorsMapper;

  /**
   * @brief Maps OpenPLX objects to AGX OSG objects
   *
   */
  class OpenPlxToOsgMapper
  {
    public:
        AGXOSG_EXPORT void createVisuals(
          const std::shared_ptr<OpenPlxToAgxVisualsMapper>& mapper, osg::Group* root);
        AGXOSG_EXPORT void createSensorVisuals(const std::shared_ptr<OpenPlxSensorsMapper>& mapper, osg::Group* root);
  };
}
