#pragma once

#include <filesystem>
#include <agxOSG/ExampleApplication.h>

namespace agxopenplx
{
    class AGXOSG_EXPORT FileChangedListener : public agxOSG::ExampleApplicationListener
    {

    public:
        /**
         * @brief Add this listener to an agxOSG::ExampleApplication to reload the scene (app->reloadScene()) when the file changes.
         *
         * \code
         * FileChangedListener* file_changed_listener = new FileChangedListener(file_to_track);
         * app->addListener(file_changed_listener)
         * \endcode
         *
         * @param file_to_track The file to track for changes.
         */
        FileChangedListener(std::string file_to_track);
        void preFrame(agxOSG::ExampleApplication *app) override;
        void postFrame(agxOSG::ExampleApplication *) override;

    private:
        std::filesystem::path m_file_to_track;
        std::filesystem::file_time_type m_last_time;
        std::chrono::steady_clock::time_point m_last_check;
    };
}
