#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/StructuralPlane.h>
#include <openplx/Vehicles/Tracks/Belt.h>
/* Generated code for model System */
namespace openplx::Vehicles::Tracks {
    /**
     * A Track system.
     * All road wheels are expected to be defined in a plane.
     * The routing of the primitives of the belt is required to be done by the runtime environment.
     * It is expected that the algorithm for routing will start from the first sprocket in the road wheel list.
     * It is also expected that the rotational axis of the first sprocket is the normal plane of the track structural plane.
     * If there are no sprockets defined, it will choose the first idler, and if there are no idlers, the first roller.
     * The initial_distance_tension defines of how stretched, in meters, each node is, which causes an initial tension in the
     * system of tracks and wheels.
     **/
    class System : public openplx::Physics3D::StructuralPlane {
        protected:
            std::shared_ptr<openplx::Vehicles::Tracks::Belt> m_belt;
            std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>> m_road_wheels;
            double m_initial_distance_tension;

        public:
            System();
            std::shared_ptr<openplx::Vehicles::Tracks::Belt> belt() const;
            std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>> road_wheels() const;
            double initial_distance_tension() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
