#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Tracks/DefaultLinkVariation.h>
#include <openplx/Vehicles/Tracks/CyclicVariation.h>
/* Generated code for model BoxLinkVariation */
namespace openplx::Vehicles::Tracks {
    /**
     * Defines the height and width of box shaped links of a belt of a track system.
     **/
    class BoxLinkVariation : public openplx::Vehicles::Tracks::DefaultLinkVariation {
        protected:
            std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation> m_height_variation;
            std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation> m_width_variation;

        public:
            BoxLinkVariation();
            std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation> height_variation() const;
            std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation> width_variation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
