#pragma once

#include <memory>
#include <openplx/Node.h>

namespace openplx {
    class SymbolMetaData : public Node, public std::enable_shared_from_this<SymbolMetaData>
    {
        public:
            static std::shared_ptr<SymbolMetaData> create();

            /* Overrides */
            void unbind() override;
            SymbolMetaDataPtr asSymbolMetaData() override;
            void accept(NodeVisitor& visitor) override;

            /* Accessors */
            TypePtr getType() const;
            TypePtr getPreviousType() const;
            TypePtr getOriginalType() const;
            ExprPtr getValue() const;
            size_t getThisOffset() const;

            NodePtr getSourceOfType() const;
            NodePtr getSourceOfValue() const;
            NodePtr getSourceOfPreviousType() const;
            NodePtr getSourceOfOriginalType() const;

            /* Mutations */
            void setSourceOfType(NodePtr source_of_type);
            void setSourceOfValue(NodePtr source_of_value);
            void setSourceOfPreviousType(NodePtr source_of_previous_type);
            void setSourceOfOriginalType(NodePtr source_of_original_type);
            void setThisOffset(size_t this_offset);

            /* Merge operations */
            void mergeLeft(SymbolMetaData& other);
            void mergeRight(SymbolMetaData& other);
            SymbolMetaDataPtr clone() const;

            std::string toString(std::string indent);

        protected:
            SymbolMetaData();
            NodePtr m_source_of_type;
            NodePtr m_source_of_value;
            NodePtr m_source_of_previous_type;
            NodePtr m_source_of_original_type;
            size_t m_this_offset;
    };
}
