#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Robotics/Joints/JointData.h>
/* Generated code for model HingeJointData */
namespace openplx::Robotics::Joints {
    class HingeJointData : public openplx::Robotics::Joints::JointData {
        protected:
            double m_stiffness_around_normal;
            double m_stiffness_around_cross;
            double m_stiffness_along_main;
            double m_stiffness_along_normal;
            double m_stiffness_along_cross;
            double m_damping_around_normal;
            double m_damping_around_cross;
            double m_damping_along_main;
            double m_damping_along_normal;
            double m_damping_along_cross;

        public:
            HingeJointData();
            double stiffness_around_normal() const;
            double stiffness_around_cross() const;
            double stiffness_along_main() const;
            double stiffness_along_normal() const;
            double stiffness_along_cross() const;
            double damping_around_normal() const;
            double damping_around_cross() const;
            double damping_along_main() const;
            double damping_along_normal() const;
            double damping_along_cross() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
