#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics/Signals/BoolInputTrait.h>
#include <openplx/Physics/Signals/BoolOutputTrait.h>
#include <openplx/Robotics/EndEffectors/VacuumSystem.h>
#include <openplx/Physics/Signals/ActivateInput.h>
#include <openplx/Physics/Signals/ActivatedOutput.h>
/* Generated code for model VacuumGripper */
namespace openplx::Robotics::EndEffectors {
    class VacuumGripper : public openplx::Core::Object, public openplx::Physics::Signals::BoolInputTrait, public openplx::Physics::Signals::BoolOutputTrait {
        protected:
            bool m_activated;
            std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>> m_suction_cups;
            std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem> m_vacuum_system;
            std::shared_ptr<openplx::Physics::Signals::ActivateInput> m_activate_input;
            std::shared_ptr<openplx::Physics::Signals::ActivatedOutput> m_activated_output;

        public:
            VacuumGripper();
            bool activated() const;
            std::vector<std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCup>> suction_cups() const;
            std::shared_ptr<openplx::Robotics::EndEffectors::VacuumSystem> vacuum_system() const;
            std::shared_ptr<openplx::Physics::Signals::ActivateInput> activate_input() const;
            std::shared_ptr<openplx::Physics::Signals::ActivatedOutput> activated_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
