#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics/Interactions/Flexibility/LinearElastic.h>
#include <openplx/Physics/Interactions/Dissipation/MechanicalDamping.h>
/* Generated code for model SuctionCupElastoDynamics */
namespace openplx::Robotics::EndEffectors {
    /**
     *     Elasticity and dissipation for a suction cup.
     *     */
    class SuctionCupElastoDynamics : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> m_lip_normal_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> m_radial_axis_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> m_around_lip_normal_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> m_around_radial_axis_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> m_lip_normal_dissipation;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> m_radial_axis_dissipation;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> m_around_lip_normal_dissipation;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> m_around_radial_axis_dissipation;

        public:
            SuctionCupElastoDynamics();
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> lip_normal_flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> radial_axis_flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> around_lip_normal_flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> around_radial_axis_flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> lip_normal_dissipation() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> radial_axis_dissipation() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> around_lip_normal_dissipation() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> around_radial_axis_dissipation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
