#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/SurfaceContact/Model.h>
#include <openplx/Physics/Interactions/SurfaceContact/PointwiseElasticity.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDryFriction.h>
/* Generated code for model PointwiseElasticityDryFrictionModel */
namespace openplx::Physics3D::Interactions::SurfaceContact {
    /**
     *     The PointwiseElasticityDryFrictionModel is a surface constact definition.
     *     An elastic contact normal model with Coulomb friction.
     *     The stiffness of the elastic part defaults to
     *     half of the harmonic mean of the youngs modulus of the two interacting materials.
     *     The relaxation time defaults to maximum relaxation time of the two interacting materials.
     *     Mechanical damping capacity [Ns/m] defaults to the stiffness [N/m] multiplied with the relaxation time [s].
     *     */
    class PointwiseElasticityDryFrictionModel : public openplx::Physics::Interactions::SurfaceContact::Model {
        protected:

        public:
            PointwiseElasticityDryFrictionModel();
            std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity> normal_flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction> friction() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
