#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/VelocityMotor.h>
#include <openplx/Physics/Signals/AngularVelocity1DInputTrait.h>
#include <openplx/Physics/Signals/AngularVelocity1DOutputTrait.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/TorqueRangeInputTrait.h>
#include <openplx/Physics/Signals/TorqueRangeOutputTrait.h>
#include <openplx/Physics/Signals/AngularVelocity1DInput.h>
#include <openplx/Physics/Signals/AngularVelocity1DOutput.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
#include <openplx/Physics/Signals/TorqueRangeInput.h>
#include <openplx/Physics/Signals/TorqueRangeOutput.h>
/* Generated code for model RotationalVelocityMotor */
namespace openplx::Physics3D::Interactions {
    class RotationalVelocityMotor : public openplx::Physics3D::Interactions::VelocityMotor, public openplx::Physics::Signals::AngularVelocity1DInputTrait, public openplx::Physics::Signals::AngularVelocity1DOutputTrait, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::TorqueRangeInputTrait, public openplx::Physics::Signals::TorqueRangeOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput> m_target_angular_velocity_input;
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> m_target_angular_velocity_output;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput> m_torque_range_input;
            std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput> m_torque_range_output;

        public:
            RotationalVelocityMotor();
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput> target_angular_velocity_input() const;
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> target_angular_velocity_output() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput> torque_range_input() const;
            std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput> torque_range_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
