#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Mate.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultCylindricalDissipation.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultCylindricalFlexibility.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultCylindricalToughness.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultFriction.h>
/* Generated code for model Cylindrical */
namespace openplx::Physics3D::Interactions {
    /**
     *     A cylindrical which constrain four degrees of freedom between two bodies.
     *     The rotation around and translation along the main axis of the two charges is free.
     *     The translational friction along and rotational friction around the axis may be specified.
     *
     *     */
    class Cylindrical : public openplx::Physics3D::Interactions::Mate {
        protected:
            double m_initial_angle;
            double m_initial_position;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> m_friction_translational;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> m_friction_rotational;

        public:
            Cylindrical();
            double initial_angle() const;
            double initial_position() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness> toughness() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> friction_translational() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> friction_rotational() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
