#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Clearance/DefaultMateClearance.h>
#include <openplx/Physics/Interactions/Clearance/ConstantDistanceClearance.h>
#include <openplx/Physics/Interactions/Clearance/ConstantAngleClearance.h>
/* Generated code for model ConstantCylindricalClearance */
namespace openplx::Physics3D::Interactions::Clearance {
    /**
     *     Clearance for the three translational dimensions for a mate
     *     and the rotation around the orthogonal axes of the main axis.
     *     */
    class ConstantCylindricalClearance : public openplx::Physics3D::Interactions::Clearance::DefaultMateClearance {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance> m_along_normal;
            std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance> m_along_cross;
            std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance> m_around_all_axes;

        public:
            ConstantCylindricalClearance();
            std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance> along_normal() const;
            std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance> along_cross() const;
            std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance> around_all_axes() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
