#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Charges/MateConnector.h>
#include <openplx/Physics3D/Bodies/Body.h>
/* Generated code for model RedirectedMateConnector */
namespace openplx::Physics3D::Charges {
    /**
     * A mate connector that is intended to be a charge of the redirected_parent.
     * It might be convenient to define mate connectors relative to
     * a different coordinate system than the body (or system) we like it to be a charge for.
     * The local transform of the charge relative the redirected_parent
     * will be defined by the mates (and SNAP) and local transforms of the owner of the
     * RedirectedMateConnector and the redirected_parent.
     * In this way, for example the mate connectors relative the bogie parts of 
     * a tracked vehicle can be defined in one coordinate system, independent of
     * which body they are relative. Then the road wheels of the tracked system can
     * SNAP to those positions, after the bogie parts have SNAP'ed in place.
     **/
    class RedirectedMateConnector : public openplx::Physics3D::Charges::MateConnector {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::Body> m_redirected_parent;

        public:
            RedirectedMateConnector();
            std::shared_ptr<openplx::Physics3D::Bodies::Body> redirected_parent() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
