#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/Value.h>
/* Generated code for model IntValue */
namespace openplx::Physics::Signals {
    /**
     * Base for Values that are integers
     **/
    class IntValue : public openplx::Physics::Signals::Value {
        protected:
            int64_t m_value;

        public:
            IntValue();
            int64_t value() const;
            static std::shared_ptr<openplx::Physics::Signals::IntValue> create(int64_t value);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
