#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Toughness/DefaultToughness.h>
/* Generated code for model ThresholdPlastic */
namespace openplx::Physics::Interactions::Toughness {
    /**
     *     Models the plastic behaviour for an interaction under stress.
     *     The yield_point defines the limit stress for yielding,
     *     Force for linear, torque for angular.
     *     */
    class ThresholdPlastic : public openplx::Physics::Interactions::Toughness::DefaultToughness {
        protected:
            double m_yield_point;

        public:
            ThresholdPlastic();
            double yield_point() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
