

#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>

namespace openplx
{
    class Expression : public Node
    {
        public:
            /* First token */
            Token getFirstToken();
            void setFirstToken(const Token& first_token);

            /* Last token */
            Token getLastToken() const;
            void setLastToken(const Token& last_token);

            /* Type */
            TypePtr getType() const;
            void setType(TypePtr type);

            /* Overrides */
            void unbind() override;

            /* Cloneable */
            virtual ExprPtr clone() = 0;

            /* Is reference */
            virtual bool isReference();

        protected:
            Expression(NodeType node_type);

            // Used in semantic analysis to keep track of expression types
            TypePtr m_type;

        private:
            // Set in parser to keep track of parenthesis, used for reporting
            // accurate column numbers in errors.
            Token m_first_token;
            Token m_last_token;
    };
}
