
#pragma once

#include <memory>
#include <stack>
#include <unordered_map>
#include <openplx/Any.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/ExpressionEvaluator.h>
#include <openplx/TopologicalPath.h>
#include <openplx/Object.h>
#include <openplx/ModelDeclaration.h>
#include <openplx/ErrorReporter.h>

namespace openplx::Core {

    /**
     * Purpose: Evaluate modeltree into runtime tree
     */
    class Evaluator
    {
        public:
            Evaluator(
                    std::shared_ptr<EvaluatorContext> ctx,
                    std::shared_ptr<ErrorReporter> error_reporter);

            /**
             * @brief Evaluate a model
             *
             * @param model_decl the model to be evaluated
             * @return std::shared_ptr<Object> Corresponding root node of runtime model
             */
            std::shared_ptr<Object> evalModel(const ModelDeclPtr& model_decl);
            virtual ~Evaluator() = default;

        private:
            std::shared_ptr<Object> getOrCreateTargetInstance(
                    const std::shared_ptr<Object>& object,
                    const TopoPathPtr& target,
                    size_t offset = 0);
            std::shared_ptr<EvaluatorContext> m_context;
            std::shared_ptr<ErrorReporter> m_error_reporter;
            std::shared_ptr<ExpressionEvaluator> m_expr_evaluator;
    };
}
