
#pragma once

#include <memory>
#include <filesystem>

namespace openplx::Core {

    class EvaluatorContext;

    using RegisterFunction = void (*)(void*);

    class DynamicFactoryLoader {
        public:
            DynamicFactoryLoader(std::shared_ptr<EvaluatorContext> _ctx) : ctx(_ctx) {}

            void loadAndRegisterFactories(std::filesystem::path dynamicLibraryPath);

        private:
            std::shared_ptr<EvaluatorContext> ctx;
    };
}
