
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>

namespace openplx
{
    class Deletion : public Node, public std::enable_shared_from_this<Deletion>
    {
        public:
            /* Factories */
            static DeletionPtr create(const std::vector<Token>& target_segments);

            /* Overrides */
            DeletionPtr asDeletion() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;

            /* Target segments */
            const std::vector<Token>& getTargetSegments() const;
            std::string targetSegmentsAsString() const;

            /* Owning model */
            ModelDeclPtr getOwningModel() const;
            void setOwningModel(ModelDeclPtr owning_model);
            std::string getSourceIdOrDefault() const;

        private:
            Deletion();
            std::vector<Token> m_target_segments;
            ModelDeclPtr m_owning_model;
    };
}
