
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Expression.h>

namespace openplx
{
    class BinaryOp : public Expression, public std::enable_shared_from_this<BinaryOp>
    {
        public:
            /* Factories */
            static BinaryOpPtr create(ExprPtr lhs, ExprPtr rhs, const Token& operator_token);

            /* Overrides */
            BinaryOpPtr asBinaryOp() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;
            ExprPtr clone() override;

            /* Operator */
            Token getOperatorToken() const;
            std::string getOpStr() const;

            /* Left hand side */
            ExprPtr getLhs() const;

            /* Right hand side */
            ExprPtr getRhs() const;

            /* Operator overload */
            void setOverloadedOperator(OpOverloadPtr op_overload);
            OpOverloadPtr getOverloadedOperator() const;

        private:
            BinaryOp();
            Token m_operator_token;
            ExprPtr m_lhs;
            ExprPtr m_rhs;
            OpOverloadPtr m_operator;
    };
}
