%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Vehicles::Tracks::Belt;
%nspace openplx::Vehicles::Tracks::BoxLinkDescription;
%nspace openplx::Vehicles::Tracks::BoxLinkVariation;
%nspace openplx::Vehicles::Tracks::ContactGeometryLinkDescription;
%nspace openplx::Vehicles::Tracks::CyclicVariation;
%nspace openplx::Vehicles::Tracks::CylindricalIdler;
%nspace openplx::Vehicles::Tracks::CylindricalRoadWheel;
%nspace openplx::Vehicles::Tracks::CylindricalRoller;
%nspace openplx::Vehicles::Tracks::CylindricalSprocket;
%nspace openplx::Vehicles::Tracks::DefaultLinkDescription;
%nspace openplx::Vehicles::Tracks::DefaultLinkVariation;
%nspace openplx::Vehicles::Tracks::DiscretePulseVariation;
%nspace openplx::Vehicles::Tracks::FixedLinkCountBelt;
%nspace openplx::Vehicles::Tracks::IntertialRoadWheel;
%nspace openplx::Vehicles::Tracks::RigidCylindricalIdler;
%nspace openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody;
%nspace openplx::Vehicles::Tracks::RigidCylindricalRoller;
%nspace openplx::Vehicles::Tracks::RigidCylindricalSprocket;
%nspace openplx::Vehicles::Tracks::RoadWheel;
%nspace openplx::Vehicles::Tracks::SinusoidalVariation;
%nspace openplx::Vehicles::Tracks::System;
%shared_ptr(openplx::Vehicles::Tracks::Belt);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::ContactGeometryLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::CyclicVariation);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::DiscretePulseVariation);
%shared_ptr(openplx::Vehicles::Tracks::FixedLinkCountBelt);
%shared_ptr(openplx::Vehicles::Tracks::IntertialRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::RoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::SinusoidalVariation);
%shared_ptr(openplx::Vehicles::Tracks::System);
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::Belt)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::BoxLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::BoxLinkVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::ContactGeometryLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CyclicVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalIdler)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalRoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalRoller)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalSprocket)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DefaultLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DefaultLinkVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DiscretePulseVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::FixedLinkCountBelt)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::IntertialRoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalIdler)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalRoller)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalSprocket)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::SinusoidalVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::System)
%include "openplx/Vehicles/Tracks/Belt.h"
%include "openplx/Vehicles/Tracks/DefaultLinkDescription.h"
%include "openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h"
%include "openplx/Vehicles/Tracks/BoxLinkDescription.h"
%include "openplx/Vehicles/Tracks/DefaultLinkVariation.h"
%include "openplx/Vehicles/Tracks/BoxLinkVariation.h"
%include "openplx/Vehicles/Tracks/CyclicVariation.h"
%include "openplx/Vehicles/Tracks/RoadWheel.h"
%include "openplx/Vehicles/Tracks/IntertialRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalIdler.h"
%include "openplx/Vehicles/Tracks/CylindricalRoller.h"
%include "openplx/Vehicles/Tracks/CylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/DiscretePulseVariation.h"
%include "openplx/Vehicles/Tracks/FixedLinkCountBelt.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalIdler.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoller.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/SinusoidalVariation.h"
%include "openplx/Vehicles/Tracks/System.h"
%ignore Vehicles_register_factories;
%include <openplx/Vehicles/Vehicles_all.h>
%inline {
    void Vehicles_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Vehicles_register_factories(eval_ctx);
    }
}
%template(VehiclesTracksBeltVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>;
%template(VehiclesTracksBoxLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>;
%template(VehiclesTracksBoxLinkVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>;
%template(VehiclesTracksContactGeometryLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>;
%template(VehiclesTracksCyclicVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>;
%template(VehiclesTracksCylindricalIdlerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>;
%template(VehiclesTracksCylindricalRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>;
%template(VehiclesTracksCylindricalRollerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>;
%template(VehiclesTracksCylindricalSprocketVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>;
%template(VehiclesTracksDefaultLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>;
%template(VehiclesTracksDefaultLinkVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>;
%template(VehiclesTracksDiscretePulseVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>;
%template(VehiclesTracksFixedLinkCountBeltVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>;
%template(VehiclesTracksIntertialRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>;
%template(VehiclesTracksRigidCylindricalIdlerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>;
%template(VehiclesTracksRigidCylindricalRoadWheelBodyVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>;
%template(VehiclesTracksRigidCylindricalRollerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>;
%template(VehiclesTracksRigidCylindricalSprocketVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>;
%template(VehiclesTracksRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>;
%template(VehiclesTracksSinusoidalVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>;
%template(VehiclesTracksSystemVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>;
