%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::DriveTrain::Actuator;
%nspace openplx::DriveTrain::AutomaticBrake;
%nspace openplx::DriveTrain::AutomaticClutch;
%nspace openplx::DriveTrain::CombustionEngine;
%nspace openplx::DriveTrain::Differential;
%nspace openplx::DriveTrain::EmpiricalTorqueConverter;
%nspace openplx::DriveTrain::FlexibleGear;
%nspace openplx::DriveTrain::Gear;
%nspace openplx::DriveTrain::GearBox;
%nspace openplx::DriveTrain::HingeActuator;
%nspace openplx::DriveTrain::ManualBrake;
%nspace openplx::DriveTrain::ManualClutch;
%nspace openplx::DriveTrain::PrismaticActuator;
%nspace openplx::DriveTrain::Shaft;
%nspace openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput;
%nspace openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput;
%nspace openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput;
%nspace openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput;
%nspace openplx::DriveTrain::Signals::TorqueConverterLockUpInput;
%nspace openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput;
%nspace openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput;
%nspace openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput;
%nspace openplx::DriveTrain::TorqueLimitedSlipDifferential;
%nspace openplx::DriveTrain::TorqueMotor;
%nspace openplx::DriveTrain::VelocityRatioGeometryFactorPair;
%nspace openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair;
%nspace openplx::DriveTrain::ViscousGear;
%shared_ptr(openplx::DriveTrain::Actuator);
%shared_ptr(openplx::DriveTrain::AutomaticBrake);
%shared_ptr(openplx::DriveTrain::AutomaticClutch);
%shared_ptr(openplx::DriveTrain::CombustionEngine);
%shared_ptr(openplx::DriveTrain::Differential);
%shared_ptr(openplx::DriveTrain::EmpiricalTorqueConverter);
%shared_ptr(openplx::DriveTrain::FlexibleGear);
%shared_ptr(openplx::DriveTrain::Gear);
%shared_ptr(openplx::DriveTrain::GearBox);
%shared_ptr(openplx::DriveTrain::HingeActuator);
%shared_ptr(openplx::DriveTrain::ManualBrake);
%shared_ptr(openplx::DriveTrain::ManualClutch);
%shared_ptr(openplx::DriveTrain::PrismaticActuator);
%shared_ptr(openplx::DriveTrain::Shaft);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterLockUpInput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput);
%shared_ptr(openplx::DriveTrain::TorqueLimitedSlipDifferential);
%shared_ptr(openplx::DriveTrain::TorqueMotor);
%shared_ptr(openplx::DriveTrain::VelocityRatioGeometryFactorPair);
%shared_ptr(openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair);
%shared_ptr(openplx::DriveTrain::ViscousGear);
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Actuator)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::AutomaticBrake)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::AutomaticClutch)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::CombustionEngine)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Differential)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::EmpiricalTorqueConverter)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::FlexibleGear)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Gear)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::GearBox)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::HingeActuator)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::ManualBrake)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::ManualClutch)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::PrismaticActuator)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Shaft)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::TorqueConverterLockUpInput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::TorqueLimitedSlipDifferential)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::TorqueMotor)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::VelocityRatioGeometryFactorPair)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair)
OPENPLX_FIX_DOWNCASTING(openplx::DriveTrain::ViscousGear)
%typemap(csimports) openplx::DriveTrain::AutomaticBrake "
/* Workaround for missing namespaces on interfaces */
using DurationInputTrait = openplx.Physics.Signals.DurationInputTrait;
using DurationOutputTrait = openplx.Physics.Signals.DurationOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::AutomaticClutch "
/* Workaround for missing namespaces on interfaces */
using DurationInputTrait = openplx.Physics.Signals.DurationInputTrait;
using DurationOutputTrait = openplx.Physics.Signals.DurationOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::CombustionEngine "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
";
%typemap(csimports) openplx::DriveTrain::EmpiricalTorqueConverter "
/* Workaround for missing namespaces on interfaces */
using RelativeVelocity1DOutputTrait = openplx.Physics.Signals.RelativeVelocity1DOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::Gear "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
using FractionOutputTrait = openplx.Physics.Signals.FractionOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::GearBox "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using IntInputTrait = openplx.Physics.Signals.IntInputTrait;
using IntOutputTrait = openplx.Physics.Signals.IntOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::ManualBrake "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using RelativeVelocity1DOutputTrait = openplx.Physics.Signals.RelativeVelocity1DOutputTrait;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
using FractionOutputTrait = openplx.Physics.Signals.FractionOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::ManualClutch "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using RelativeVelocity1DOutputTrait = openplx.Physics.Signals.RelativeVelocity1DOutputTrait;
using FractionInputTrait = openplx.Physics.Signals.FractionInputTrait;
using FractionOutputTrait = openplx.Physics.Signals.FractionOutputTrait;
";
%typemap(csimports) openplx::DriveTrain::TorqueMotor "
/* Workaround for missing namespaces on interfaces */
using Torque1DOutputTrait = openplx.Physics.Signals.Torque1DOutputTrait;
using Torque1DInputTrait = openplx.Physics.Signals.Torque1DInputTrait;
";
%include "openplx/DriveTrain/Actuator.h"
%include "openplx/DriveTrain/ManualBrake.h"
%include "openplx/DriveTrain/AutomaticBrake.h"
%include "openplx/DriveTrain/ManualClutch.h"
%include "openplx/DriveTrain/AutomaticClutch.h"
%include "openplx/DriveTrain/CombustionEngine.h"
%include "openplx/DriveTrain/Differential.h"
%include "openplx/DriveTrain/EmpiricalTorqueConverter.h"
%include "openplx/DriveTrain/Gear.h"
%include "openplx/DriveTrain/FlexibleGear.h"
%include "openplx/DriveTrain/GearBox.h"
%include "openplx/DriveTrain/HingeActuator.h"
%include "openplx/DriveTrain/PrismaticActuator.h"
%include "openplx/DriveTrain/Shaft.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationInput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationOutput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationInput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterLockUpInput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterLockedUpOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterPumpTorqueOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterTurbineTorqueOutput.h"
%include "openplx/DriveTrain/TorqueLimitedSlipDifferential.h"
%include "openplx/DriveTrain/TorqueMotor.h"
%include "openplx/DriveTrain/VelocityRatioGeometryFactorPair.h"
%include "openplx/DriveTrain/VelocityRatioTorqueMultiplicationPair.h"
%include "openplx/DriveTrain/ViscousGear.h"
%ignore DriveTrain_register_factories;
%include <openplx/DriveTrain/DriveTrain_all.h>
%inline {
    void DriveTrain_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        DriveTrain_register_factories(eval_ctx);
    }
}
%template(DriveTrainActuatorVector) std::vector<std::shared_ptr<openplx::DriveTrain::Actuator>>;
%template(DriveTrainAutomaticBrakeVector) std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticBrake>>;
%template(DriveTrainAutomaticClutchVector) std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticClutch>>;
%template(DriveTrainCombustionEngineVector) std::vector<std::shared_ptr<openplx::DriveTrain::CombustionEngine>>;
%template(DriveTrainDifferentialVector) std::vector<std::shared_ptr<openplx::DriveTrain::Differential>>;
%template(DriveTrainEmpiricalTorqueConverterVector) std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>>;
%template(DriveTrainFlexibleGearVector) std::vector<std::shared_ptr<openplx::DriveTrain::FlexibleGear>>;
%template(DriveTrainGearVector) std::vector<std::shared_ptr<openplx::DriveTrain::Gear>>;
%template(DriveTrainGearBoxVector) std::vector<std::shared_ptr<openplx::DriveTrain::GearBox>>;
%template(DriveTrainHingeActuatorVector) std::vector<std::shared_ptr<openplx::DriveTrain::HingeActuator>>;
%template(DriveTrainManualBrakeVector) std::vector<std::shared_ptr<openplx::DriveTrain::ManualBrake>>;
%template(DriveTrainManualClutchVector) std::vector<std::shared_ptr<openplx::DriveTrain::ManualClutch>>;
%template(DriveTrainPrismaticActuatorVector) std::vector<std::shared_ptr<openplx::DriveTrain::PrismaticActuator>>;
%template(DriveTrainShaftVector) std::vector<std::shared_ptr<openplx::DriveTrain::Shaft>>;
%template(DriveTrainSignalsAutomaticClutchDisengagementDurationInputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>>;
%template(DriveTrainSignalsAutomaticClutchDisengagementDurationOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>>;
%template(DriveTrainSignalsAutomaticClutchEngagementDurationInputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>>;
%template(DriveTrainSignalsAutomaticClutchEngagementDurationOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>>;
%template(DriveTrainSignalsTorqueConverterLockUpInputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>>;
%template(DriveTrainSignalsTorqueConverterLockedUpOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>>;
%template(DriveTrainSignalsTorqueConverterPumpTorqueOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>>;
%template(DriveTrainSignalsTorqueConverterTurbineTorqueOutputVector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>>;
%template(DriveTrainTorqueLimitedSlipDifferentialVector) std::vector<std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>>;
%template(DriveTrainTorqueMotorVector) std::vector<std::shared_ptr<openplx::DriveTrain::TorqueMotor>>;
%template(DriveTrainVelocityRatioGeometryFactorPairVector) std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>>;
%template(DriveTrainVelocityRatioTorqueMultiplicationPairVector) std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>>;
%template(DriveTrainViscousGearVector) std::vector<std::shared_ptr<openplx::DriveTrain::ViscousGear>>;
