/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxTerrain/Terrain.h>
#include <agxTerrain/FailureSurface.h>
#include <agxTerrain/GroundCollapseUtils.h>
#include <agxRender/Color.h>


namespace agxTerrain
{
  namespace GroundCollapse
  {
    void AGXTERRAIN_EXPORT render2DCircle(
      const agx::Vec3& midpoint,
      agx::Real radius,
      const agx::Quat& rotation,
      agx::UInt numPoints,
      const agxRender::Color& color,
      agx::Real size = 0.1 );

    void AGXTERRAIN_EXPORT debugRenderFailureSurface(
      const agxTerrain::Terrain* terrain,
      const GroundCollapse::FailureSurface* surface,
      agx::Real size,
      const agxRender::Color& color );

    void AGXTERRAIN_EXPORT debugRenderFailureSurfacePoints(
      const agxTerrain::Terrain* terrain,
      const GroundCollapse::FailureSurface* surface );

    void AGXTERRAIN_EXPORT debugRenderContacts(
      const GroundCollapse::ContactResultVector& points,
      agx::Real size,
      bool colorAccordingToFailure);

    void AGXTERRAIN_EXPORT debugRenderContactPartitioning(
      const agxTerrain::Terrain* terrain,
      const GroundCollapse::FailureSurface* surface,
      const GroundCollapse::LoadPointVector& loadPoints,
      agx::UInt colorIndex );

    void AGXTERRAIN_EXPORT debugRenderAggregateMassVoxels(
      const agxTerrain::Terrain* terrain,
      const GroundCollapse::FailureSurfaceAggregate* aggregate);

    void AGXTERRAIN_EXPORT debugRenderAggregateBorderVoxels(
      const agxTerrain::Terrain* terrain,
      const GroundCollapse::FailureSurfaceAggregate* aggregate );

    void AGXTERRAIN_EXPORT renderSlopeData( SlopeUtils::SlopeData& slope,
                                            agx::Real size );

    agxRender::Color AGXTERRAIN_EXPORT interpolateColor( agx::Real scalar );
  }
}
