#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Tracks/CylindricalRoadWheel.h>
/* Generated code for model CylindricalRoller */
namespace openplx::Vehicles::Tracks {
    /**
     * Rollers, both road rollers and return rollers, in tracked vehicles
     * are the wheels that bear the weight of the vehicle or guide the track
     * on its return path after it leaves the sprocket.
     * They spin freely and are not motorized. 
     * They facilitate the movement of the tracks around the path.
     **/
    class CylindricalRoller : public openplx::Vehicles::Tracks::CylindricalRoadWheel {
        protected:

        public:
            CylindricalRoller();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
