#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Urdf/UrdfForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Visuals/VisualsForward.h>
/* Generated code for model PackagePath */
namespace openplx::Urdf {
    /**
     * This is a package path for a URDF package. It is used to specify the location of files that URDFs depend on.
     *
     * Example:
     *
     * MyRobot is Robot:
     *     package_path is Urdf.PackagePath:
     *         name: "my_package"
     *         path: @"../packages/my_package"
     **/
    class PackagePath : public openplx::Core::Object {
        protected:
            std::string m_name;
            std::string m_path;

        public:
            PackagePath();
            std::string name() const;
            std::string path() const;
            void on_init(const openplx::RuntimeContext& context) override;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
