
#pragma once

#include <openplx/Node.h>
#include <openplx/Document.h>

namespace openplx
{
    class Type : public Node
    {
        public:
            virtual std::string toString() = 0;

            /**
             * String representation with safe characters to use in serialization
             * and transpilation.
             */
            virtual std::string toKey() = 0;

            virtual bool isAssignableTo(const TypePtr& other) = 0;

        protected:
            Type(NodeType type);
    };
}
