#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Terrain/TerrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/Bodies/Body.h>
#include <openplx/Terrain/TerrainMaterial.h>
/* Generated code for model Terrain */
namespace openplx::Terrain {
    /**
     *     A Terrain is modifiable by Shovels
     *
     *     num_elements_x - defines the number of elements in the x direction.
     *     num_elements_y - defines the number of elements in the y direction.
     *     element_size - The distance between the height points in the terrain
     *     max_depth - The maximum depth that the terrain can have.
     *
     *     The size of the terrain is thus (num_elements_x-1)*element_size x (num_elements_y-1)*element_size
     *
     *     Example:
     *
     *     Scene is Physics3D.System:
     *     local_transform.position.x: 1
     *     terrain is Terrain.Terrain:
     *         num_elements_x: 151
     *         num_elements_y: 201
     *         element_size: 0.10
     *         max_depth: 5.0
     *         # Let terrain starts at origo
     *         kinematics.local_transform.position.x: (terrain.num_elements_x-1)/2*terrain.element_size
     *         kinematics.local_transform.position.y: (terrain.num_elements_y-1)/2*terrain.element_size
     *
     *     */
    class Terrain : public openplx::Physics3D::Bodies::Body {
        protected:
            int64_t m_num_elements_x;
            int64_t m_num_elements_y;
            double m_element_size;
            double m_max_depth;
            std::shared_ptr<openplx::Terrain::TerrainMaterial> m_material;

        public:
            Terrain();
            int64_t num_elements_x() const;
            int64_t num_elements_y() const;
            double element_size() const;
            double max_depth() const;
            std::shared_ptr<openplx::Terrain::TerrainMaterial> material() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
