#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Terrain/TerrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Math/Line.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model Shovel */
namespace openplx::Terrain {
    /**
     *     A Shovel can be used to modify terrain
     *
     *     Example:
     *
     *     Scene is Physics3D.System:
     *         shovel_body is ShovelRigidBody
     *         shovel is Terrain.Shovel:
     *             body: shovel_body
     *             top_edge: Math.Line.from_points(shovel_body.top_left, shovel_body.top_right)
     *             cutting_edge: Math.Line.from_points(shovel_body.bottom_left, shovel_body.bottom_right)
     *             cutting_direction: shovel_body.forward
     *
     *     */
    class Shovel : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_body;
            std::shared_ptr<openplx::Math::Line> m_top_edge;
            std::shared_ptr<openplx::Math::Line> m_cutting_edge;
            std::shared_ptr<openplx::Math::Vec3> m_cutting_direction;

        public:
            Shovel();
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> body() const;
            std::shared_ptr<openplx::Math::Line> top_edge() const;
            std::shared_ptr<openplx::Math::Line> cutting_edge() const;
            std::shared_ptr<openplx::Math::Vec3> cutting_direction() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
