#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultMateToughness.h>
#include <openplx/Physics/Interactions/Toughness/DefaultToughness.h>
/* Generated code for model DefaultBallToughness */
namespace openplx::Physics3D::Interactions::Toughness {
    /**
     *     Defines one toughness model for each constrained degree of freedom for a Lock
     *     */
    class DefaultBallToughness : public openplx::Physics3D::Interactions::Toughness::DefaultMateToughness {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness> m_along_main;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness> m_along_normal;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness> m_along_cross;

        public:
            DefaultBallToughness();
            std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness> along_main() const;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness> along_normal() const;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness> along_cross() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
