#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Mate.h>
#include <openplx/Physics/Signals/Position1DOutputTrait.h>
#include <openplx/Physics/Signals/LinearVelocity1DOutputTrait.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultPrismaticDissipation.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultPrismaticFlexibility.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultPrismaticToughness.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultFriction.h>
#include <openplx/Physics/Signals/Position1DOutput.h>
#include <openplx/Physics/Signals/LinearVelocity1DOutput.h>
/* Generated code for model Prismatic */
namespace openplx::Physics3D::Interactions {
    /**
     *     A prismatic which constrain five degrees of freedom between two bodies.
     *     The translation along the main axis of the two charges is free.
     *     By setting a dry friction coefficient > 0, friction forces will be computed
     *     using a normal force defined by the prismatic forces orthogonal to the main axis.
     *     */
    class Prismatic : public openplx::Physics3D::Interactions::Mate, public openplx::Physics::Signals::Position1DOutputTrait, public openplx::Physics::Signals::LinearVelocity1DOutputTrait {
        protected:
            double m_initial_position;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> m_friction;
            std::shared_ptr<openplx::Physics::Signals::Position1DOutput> m_position_output;
            std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput> m_velocity_output;

        public:
            Prismatic();
            double initial_position() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness> toughness() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> friction() const;
            std::shared_ptr<openplx::Physics::Signals::Position1DOutput> position_output() const;
            std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput> velocity_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
