#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Charges/MateConnector.h>
/* Generated code for model AdaptiveMateConnector */
namespace openplx::Physics3D::Charges {
    /**
     *     
     *     When using one AdaptiveMateConnector in a mate, 
     *     it will transform to the relative position of the owning body/system so that it aligns with the other mate connector.
     *     There can't be any degrees of freedom left between the MateConnectors, meaning that SNAP has done the work already. 
     *     This feature can be used to introduce interactions in a non-violated state, without having to specify 
     *     initial conditions for all 6 degrees of freedom for two mate connectors.
     *     For example, a mate connector for the suspension that is defined given the chassis of the car may mate with the 
     *     other parts, and just adapt to how these are placed relative the chassis.
     *     */
    class AdaptiveMateConnector : public openplx::Physics3D::Charges::MateConnector {
        protected:

        public:
            AdaptiveMateConnector();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
